/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.serializer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.atomix.cluster.MemberId;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossipState;
import io.camunda.zeebe.topology.protocol.Topology;
import io.camunda.zeebe.topology.serializer.ClusterTopologySerializer;
import io.camunda.zeebe.topology.serializer.DecodingFailed;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProtoBufSerializer
implements ClusterTopologySerializer {
    @Override
    public byte[] encode(ClusterTopologyGossipState gossipState) {
        Topology.GossipState.Builder builder = Topology.GossipState.newBuilder();
        ClusterTopology topologyToEncode = gossipState.getClusterTopology();
        if (topologyToEncode != null) {
            Topology.ClusterTopology clusterTopology = this.encodeClusterTopology(topologyToEncode);
            builder.setClusterTopology(clusterTopology);
        }
        Topology.GossipState message = builder.build();
        return message.toByteArray();
    }

    @Override
    public ClusterTopologyGossipState decode(byte[] encodedState) {
        Topology.GossipState gossipState;
        try {
            gossipState = Topology.GossipState.parseFrom(encodedState);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
        ClusterTopologyGossipState clusterTopologyGossipState = new ClusterTopologyGossipState();
        if (gossipState.hasClusterTopology()) {
            clusterTopologyGossipState.setClusterTopology(this.decodeClusterTopology(gossipState.getClusterTopology()));
        }
        return clusterTopologyGossipState;
    }

    @Override
    public byte[] encode(ClusterTopology clusterTopology) {
        return this.encodeClusterTopology(clusterTopology).toByteArray();
    }

    @Override
    public ClusterTopology decodeClusterTopology(byte[] encodedClusterTopology) {
        try {
            Topology.ClusterTopology topology = Topology.ClusterTopology.parseFrom(encodedClusterTopology);
            return this.decodeClusterTopology(topology);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    private ClusterTopology decodeClusterTopology(Topology.ClusterTopology encodedClusterTopology) {
        Map<MemberId, MemberState> members = encodedClusterTopology.getMembersMap().entrySet().stream().map(e -> Map.entry(MemberId.from((String)((String)e.getKey())), this.decodeMemberState((Topology.MemberState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ClusterChangePlan changes = this.decodeChangePlan(encodedClusterTopology.getChanges());
        return new ClusterTopology(encodedClusterTopology.getVersion(), members, changes);
    }

    private Topology.ClusterTopology encodeClusterTopology(ClusterTopology clusterTopology) {
        Map<String, Topology.MemberState> members = clusterTopology.members().entrySet().stream().collect(Collectors.toMap(e -> (String)((Object)((MemberId)e.getKey()).id()), e -> this.encodeMemberState((MemberState)e.getValue())));
        Topology.ClusterChangePlan encodedChangePlan = this.encodeChangePlan(clusterTopology.changes());
        return Topology.ClusterTopology.newBuilder().setVersion(clusterTopology.version()).putAllMembers(members).setChanges(encodedChangePlan).build();
    }

    private MemberState decodeMemberState(Topology.MemberState memberState) {
        Map<Integer, PartitionState> partitions = memberState.getPartitionsMap().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.decodePartitionState((Topology.PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Timestamp lastUpdated = memberState.getLastUpdated();
        return new MemberState(memberState.getVersion(), Instant.ofEpochSecond(lastUpdated.getSeconds(), lastUpdated.getNanos()), this.toMemberState(memberState.getState()), partitions);
    }

    private PartitionState decodePartitionState(Topology.PartitionState partitionState) {
        return new PartitionState(this.toPartitionState(partitionState.getState()), partitionState.getPriority());
    }

    private Topology.MemberState encodeMemberState(MemberState memberState) {
        Map<Integer, Topology.PartitionState> partitions = memberState.partitions().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.encodePartitions((PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Instant lastUpdated = memberState.lastUpdated();
        return Topology.MemberState.newBuilder().setVersion(memberState.version()).setLastUpdated(Timestamp.newBuilder().setSeconds(lastUpdated.getEpochSecond()).setNanos(lastUpdated.getNano()).build()).setState(this.toSerializedState(memberState.state())).putAllPartitions(partitions).build();
    }

    private Topology.PartitionState encodePartitions(PartitionState partitionState) {
        return Topology.PartitionState.newBuilder().setState(this.toSerializedState(partitionState.state())).setPriority(partitionState.priority()).build();
    }

    private Topology.State toSerializedState(MemberState.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case MemberState.State.UNINITIALIZED -> Topology.State.UNKNOWN;
            case MemberState.State.ACTIVE -> Topology.State.ACTIVE;
            case MemberState.State.JOINING -> Topology.State.JOINING;
            case MemberState.State.LEAVING -> Topology.State.LEAVING;
            case MemberState.State.LEFT -> Topology.State.LEFT;
        };
    }

    private MemberState.State toMemberState(Topology.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN -> MemberState.State.UNINITIALIZED;
            case Topology.State.ACTIVE -> MemberState.State.ACTIVE;
            case Topology.State.JOINING -> MemberState.State.JOINING;
            case Topology.State.LEAVING -> MemberState.State.LEAVING;
            case Topology.State.LEFT -> MemberState.State.LEFT;
        };
    }

    private PartitionState.State toPartitionState(Topology.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN, Topology.State.LEFT -> PartitionState.State.UNKNOWN;
            case Topology.State.ACTIVE -> PartitionState.State.ACTIVE;
            case Topology.State.JOINING -> PartitionState.State.JOINING;
            case Topology.State.LEAVING -> PartitionState.State.LEAVING;
        };
    }

    private Topology.State toSerializedState(PartitionState.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case PartitionState.State.UNKNOWN -> Topology.State.UNKNOWN;
            case PartitionState.State.ACTIVE -> Topology.State.ACTIVE;
            case PartitionState.State.JOINING -> Topology.State.JOINING;
            case PartitionState.State.LEAVING -> Topology.State.LEAVING;
        };
    }

    private Topology.ClusterChangePlan encodeChangePlan(ClusterChangePlan changes) {
        Topology.ClusterChangePlan.Builder builder = Topology.ClusterChangePlan.newBuilder().setVersion(changes.version());
        changes.pendingOperations().forEach(operation -> builder.addOperation(this.encodeOperation((TopologyChangeOperation)operation)));
        return builder.build();
    }

    private Topology.TopologyChangeOperation encodeOperation(TopologyChangeOperation operation) {
        Topology.TopologyChangeOperation.Builder builder = Topology.TopologyChangeOperation.newBuilder().setMemberId((String)((Object)operation.memberId().id()));
        if (operation instanceof TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation) {
            TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)operation;
            builder.setPartitionJoin(Topology.PartitionJoinOperation.newBuilder().setPartitionId(joinOperation.partitionId()).setPriority(joinOperation.priority()));
        } else if (operation instanceof TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation) {
            TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)operation;
            builder.setPartitionLeave(Topology.PartitionLeaveOperation.newBuilder().setPartitionId(leaveOperation.partitionId()));
        } else if (operation instanceof TopologyChangeOperation.MemberJoinOperation) {
            builder.setMemberJoin(Topology.MemberJoinOperation.newBuilder().build());
        } else if (operation instanceof TopologyChangeOperation.MemberLeaveOperation) {
            builder.setMemberLeave(Topology.MemberLeaveOperation.newBuilder().build());
        } else {
            throw new IllegalArgumentException("Unknown operation type: " + operation.getClass().getSimpleName());
        }
        return builder.build();
    }

    private ClusterChangePlan decodeChangePlan(Topology.ClusterChangePlan clusterChangePlan) {
        int version = clusterChangePlan.getVersion();
        List<TopologyChangeOperation> pendingOperations = clusterChangePlan.getOperationList().stream().map(this::decodeOperation).toList();
        return new ClusterChangePlan(version, pendingOperations);
    }

    private TopologyChangeOperation decodeOperation(Topology.TopologyChangeOperation topologyChangeOperation) {
        if (topologyChangeOperation.hasPartitionJoin()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionJoin().getPartitionId(), topologyChangeOperation.getPartitionJoin().getPriority());
        }
        if (topologyChangeOperation.hasPartitionLeave()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionLeave().getPartitionId());
        }
        if (topologyChangeOperation.hasMemberJoin()) {
            return new TopologyChangeOperation.MemberJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        if (topologyChangeOperation.hasMemberLeave()) {
            return new TopologyChangeOperation.MemberLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        throw new IllegalStateException("Unknown operation: " + topologyChangeOperation);
    }
}

