/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.state;

import com.google.common.collect.ImmutableMap;
import io.atomix.cluster.MemberId;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record ClusterTopology(long version, Map<MemberId, MemberState> members, ClusterChangePlan changes) {
    private static final int UNINITIALIZED_VERSION = -1;

    public static ClusterTopology uninitialized() {
        return new ClusterTopology(-1L, Map.of(), ClusterChangePlan.empty());
    }

    public boolean isUninitialized() {
        return this.version == -1L;
    }

    public static ClusterTopology init() {
        return new ClusterTopology(0L, Map.of(), ClusterChangePlan.empty());
    }

    public ClusterTopology addMember(MemberId memberId, MemberState state) {
        if (this.members.containsKey(memberId)) {
            throw new IllegalStateException(String.format("Expected add a new member, but member %s already exists with state %s", memberId.id(), this.members.get(memberId)));
        }
        ImmutableMap newMembers = ImmutableMap.builder().putAll(this.members).put((Object)memberId, (Object)state).build();
        return new ClusterTopology(this.version, (Map<MemberId, MemberState>)newMembers, this.changes);
    }

    public ClusterTopology updateMember(MemberId memberId, UnaryOperator<MemberState> memberStateUpdater) {
        MemberState updateMemberState;
        MemberState currentState = this.members.get(memberId);
        if (Objects.equals(currentState, updateMemberState = (MemberState)memberStateUpdater.apply(currentState))) {
            return this;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (updateMemberState != null) {
            mapBuilder.putAll(this.members).put((Object)memberId, (Object)updateMemberState);
        } else {
            mapBuilder.putAll(this.members.entrySet().stream().filter(entry -> !((MemberId)entry.getKey()).equals((Object)memberId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        ImmutableMap newMembers = mapBuilder.buildKeepingLast();
        return new ClusterTopology(this.version, (Map<MemberId, MemberState>)newMembers, this.changes);
    }

    public ClusterTopology startTopologyChange(List<TopologyChangeOperation> operations) {
        if (this.hasPendingChanges()) {
            throw new IllegalArgumentException("Expected to start new topology change, but there is a topology change in progress " + this.changes);
        }
        if (operations.isEmpty()) {
            throw new IllegalArgumentException("Expected to start new topology change, but there is no operation");
        }
        return new ClusterTopology(this.version + 1L, this.members, ClusterChangePlan.init(operations));
    }

    public ClusterTopology merge(ClusterTopology other) {
        if (this.version > other.version) {
            return this;
        }
        if (other.version > this.version) {
            return other;
        }
        Map<MemberId, MemberState> mergedMembers = Stream.concat(this.members.entrySet().stream(), other.members().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, MemberState::merge));
        ClusterChangePlan mergedChanges = this.changes.merge(other.changes);
        return new ClusterTopology(this.version, (Map<MemberId, MemberState>)ImmutableMap.copyOf(mergedMembers), mergedChanges);
    }

    private boolean hasPendingChangesFor(MemberId memberId) {
        return !this.changes.pendingOperations().isEmpty() && this.changes.pendingOperations().get(0).memberId().equals((Object)memberId);
    }

    public Optional<TopologyChangeOperation> pendingChangesFor(MemberId memberId) {
        if (!this.hasPendingChangesFor(memberId)) {
            return Optional.empty();
        }
        return Optional.of(this.changes.pendingOperations().get(0));
    }

    public ClusterTopology advanceTopologyChange(MemberId memberId, UnaryOperator<MemberState> memberStateUpdater) {
        return this.updateMember(memberId, memberStateUpdater).advance();
    }

    private ClusterTopology advance() {
        if (!this.hasPendingChanges()) {
            throw new IllegalStateException("Expected to advance the topology change, but there is no pending change");
        }
        ClusterTopology result = new ClusterTopology(this.version, this.members, this.changes.advance());
        if (!result.hasPendingChanges()) {
            Map<MemberId, MemberState> currentMembers = result.members().entrySet().stream().filter(entry -> ((MemberState)entry.getValue()).state() != MemberState.State.LEFT).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new ClusterTopology(result.version() + 1L, currentMembers, ClusterChangePlan.empty());
        }
        return result;
    }

    public boolean hasMember(MemberId memberId) {
        return this.members().containsKey(memberId);
    }

    public MemberState getMember(MemberId memberId) {
        return this.members().get(memberId);
    }

    public boolean hasPendingChanges() {
        return !this.changes.pendingOperations().isEmpty();
    }

    public int clusterSize() {
        return (int)this.members.entrySet().stream().filter(entry -> ((MemberState)entry.getValue()).state() != MemberState.State.LEFT && ((MemberState)entry.getValue()).state() != MemberState.State.UNINITIALIZED).count();
    }

    public int partitionCount() {
        return (int)this.members.values().stream().flatMap(m -> m.partitions().keySet().stream()).distinct().count();
    }
}

