/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.state;

public record PartitionState(State state, int priority) {
    public static PartitionState active(int priority) {
        return new PartitionState(State.ACTIVE, priority);
    }

    public static PartitionState joining(int priority) {
        return new PartitionState(State.JOINING, priority);
    }

    public PartitionState toActive() {
        if (this.state == State.LEAVING) {
            throw new IllegalStateException(String.format("Cannot transition to ACTIVE when current state is %s", new Object[]{this.state}));
        }
        return new PartitionState(State.ACTIVE, this.priority);
    }

    public PartitionState toLeaving() {
        return new PartitionState(State.LEAVING, this.priority);
    }

    public static enum State {
        UNKNOWN,
        JOINING,
        ACTIVE,
        LEAVING;

    }
}

