/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.impl.AggregatedClientStream;
import io.camunda.zeebe.transport.stream.impl.LogicalId;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientStreamRegistration<M extends BufferWriter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStreamRegistration.class);
    private final AggregatedClientStream<M> stream;
    private final MemberId serverId;
    private State state = State.INITIAL;
    private CompletionStage<byte[]> pendingRequest;

    ClientStreamRegistration(AggregatedClientStream<M> stream, MemberId serverId) {
        this.stream = stream;
        this.serverId = serverId;
    }

    UUID streamId() {
        return this.stream.getStreamId();
    }

    LogicalId<? extends BufferWriter> logicalId() {
        return this.stream.logicalId();
    }

    MemberId serverId() {
        return this.serverId;
    }

    State state() {
        return this.state;
    }

    CompletionStage<byte[]> pendingRequest() {
        return this.pendingRequest;
    }

    void setPendingRequest(CompletionStage<byte[]> pendingRequest) {
        this.pendingRequest = pendingRequest;
    }

    boolean transitionToAdding() {
        return this.transition(State.ADDING, EnumSet.of(State.INITIAL));
    }

    void transitionToAdded() {
        if (this.transition(State.ADDED, EnumSet.of(State.ADDING))) {
            this.stream.add(this.serverId);
        }
    }

    boolean transitionToRemoving() {
        return this.transition(State.REMOVING, EnumSet.of(State.INITIAL, State.ADDING, State.ADDED));
    }

    void transitionToRemoved() {
        if (this.transition(State.REMOVED, EnumSet.of(State.INITIAL, State.REMOVING))) {
            this.stream.remove(this.serverId);
        }
    }

    void transitionToClosed() {
        this.transition(State.CLOSED, EnumSet.allOf(State.class));
        this.stream.remove(this.serverId);
    }

    private boolean transition(State target, Set<State> allowed) {
        if (!allowed.contains((Object)this.state)) {
            this.logSkippedTransition(target);
            return false;
        }
        this.state = target;
        LOGGER.trace("{} remote client stream {} on server {}", new Object[]{target, this.stream.getStreamId(), this.serverId});
        return true;
    }

    private void logSkippedTransition(State target) {
        LOGGER.trace("Skip {} transition of stream {} on {} as its state is {}", new Object[]{target, this.stream.getStreamId(), this.serverId, this.state});
    }

    static enum State {
        INITIAL,
        ADDING,
        ADDED,
        REMOVING,
        REMOVED,
        CLOSED;

    }
}

