/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.UUIDEncoder;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.UUID;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStreamApiHandler<M>
implements CloseableSilently {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStreamApiHandler.class);
    private static final UUID NULL_ID = new UUID(UUIDEncoder.highNullValue(), UUIDEncoder.lowNullValue());
    private final RemoteStreamRegistry<M> registry;
    private final Function<DirectBuffer, M> metadataFactory;

    public RemoteStreamApiHandler(RemoteStreamRegistry<M> registry, Function<DirectBuffer, M> metadataFactory) {
        this.registry = registry;
        this.metadataFactory = metadataFactory;
    }

    public void close() {
        this.registry.clear();
    }

    public void add(MemberId sender, AddStreamRequest request) {
        M properties = this.metadataFactory.apply(request.metadata());
        if (request.streamType().capacity() <= 0) {
            String errorMessage = "Expected a stream type of length > 0, but it has %d".formatted(request.streamType().capacity());
            LOG.warn("Failed to open stream for '{}': [{}]", (Object)sender, (Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (request.streamId() == null || request.streamId().equals(NULL_ID)) {
            String errorMessage = "Expected a stream ID, but received a nil UUID ([%s])".formatted(request.streamId());
            LOG.warn("Failed to open stream for '{}': [{}]", (Object)sender, (Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.registry.add(new UnsafeBuffer(request.streamType()), request.streamId(), sender, properties);
        LOG.debug("Opened stream {} from {}", (Object)request.streamId(), (Object)sender);
    }

    public void remove(MemberId sender, RemoveStreamRequest request) {
        this.registry.remove(request.streamId(), sender);
        LOG.debug("Removed stream {} from {}", (Object)request.streamId(), (Object)sender);
    }

    public void removeAll(MemberId sender) {
        this.registry.removeAll(sender);
        LOG.debug("Removed all streams from {}", (Object)sender);
    }
}

