/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.camunda.zeebe.transport.stream.api.RemoteStream;
import io.camunda.zeebe.transport.stream.api.RemoteStreamErrorHandler;
import io.camunda.zeebe.transport.stream.api.StreamExhaustedException;
import io.camunda.zeebe.transport.stream.impl.AggregatedRemoteStream;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamPusher;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStreamImpl<M, P extends BufferWriter>
implements RemoteStream<M, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStreamImpl.class);
    private final AggregatedRemoteStream<M> stream;
    private final RemoteStreamPusher<P> streamer;
    private final RemoteStreamErrorHandler<P> errorHandler;

    public RemoteStreamImpl(AggregatedRemoteStream<M> stream, RemoteStreamPusher<P> streamer, RemoteStreamErrorHandler<P> errorHandler) {
        this.stream = stream;
        this.streamer = streamer;
        this.errorHandler = errorHandler;
    }

    @Override
    public M metadata() {
        return this.stream.logicalId().metadata();
    }

    @Override
    public void push(P payload) {
        AggregatedRemoteStream.StreamConsumer<M> initialConsumer = this.pickInitialConsumer();
        if (initialConsumer == null) {
            this.errorHandler.handleError(new StreamExhaustedException("Failed to push to stream %s, all consumers were removed since it was picked".formatted(this.stream.logicalId())), payload);
            return;
        }
        RetryHandler retryHandler = new RetryHandler(this.errorHandler, initialConsumer);
        this.streamer.pushAsync(payload, retryHandler, initialConsumer.id());
    }

    private AggregatedRemoteStream.StreamConsumer<M> pickInitialConsumer() {
        List<AggregatedRemoteStream.StreamConsumer<M>> consumers = this.stream.streamConsumers();
        int size = consumers.size();
        while (size > 0) {
            int index = ThreadLocalRandom.current().nextInt(size);
            try {
                return consumers.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.trace("Stream consumer list concurrently modified while picking consumer; retrying", (Throwable)e);
                size = consumers.size();
            }
        }
        return null;
    }

    private final class RetryHandler
    implements RemoteStreamErrorHandler<P> {
        private final RemoteStreamErrorHandler<P> errorHandler;
        private final AggregatedRemoteStream.StreamConsumer<M> initialConsumer;

        private RetryHandler(RemoteStreamErrorHandler<P> errorHandler, AggregatedRemoteStream.StreamConsumer<M> initialConsumer) {
            this.errorHandler = errorHandler;
            this.initialConsumer = initialConsumer;
        }

        @Override
        public void handleError(Throwable error, P data) {
            ArrayList consumers = new ArrayList(RemoteStreamImpl.this.stream.streamConsumers());
            if (consumers.isEmpty()) {
                this.onConsumersExhausted(error, data);
                return;
            }
            consumers.remove(this.initialConsumer);
            Collections.shuffle(consumers);
            Iterator iterator = consumers.iterator();
            this.retry(error, data, iterator);
        }

        private void retry(Throwable throwable, P payload, Iterator<AggregatedRemoteStream.StreamConsumer<M>> iterator) {
            if (!iterator.hasNext()) {
                this.onConsumersExhausted(throwable, payload);
                return;
            }
            AggregatedRemoteStream.StreamConsumer client = iterator.next();
            LOGGER.debug("Failed to push payload {}, retrying with next stream", payload);
            RemoteStreamImpl.this.streamer.pushAsync((BufferWriter)payload, (error, data) -> this.retry(error, data, iterator), client.id());
        }

        private void onConsumersExhausted(Throwable throwable, P payload) {
            LOGGER.debug("Failed to push payload {}, no more streams to retry", payload);
            this.errorHandler.handleError(throwable, payload);
        }
    }
}

