/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.MessagingException;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamApiHandler;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.MessageUtil;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.StreamTopics;
import io.camunda.zeebe.util.ExponentialBackoff;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.agrona.collections.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStreamTransport<M>
extends Actor {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStreamTransport.class);
    private static final int INITIAL_RETRY_DELAY_MS = 100;
    private final ClusterCommunicationService transport;
    private final RemoteStreamApiHandler<M> requestHandler;
    private final LongUnaryOperator retryDelaySupplier;

    public RemoteStreamTransport(ClusterCommunicationService transport, RemoteStreamApiHandler<M> requestHandler) {
        this(transport, requestHandler, (LongUnaryOperator)new ExponentialBackoff());
    }

    RemoteStreamTransport(ClusterCommunicationService transport, RemoteStreamApiHandler<M> requestHandler, LongUnaryOperator retryDelaySupplier) {
        this.transport = transport;
        this.requestHandler = requestHandler;
        this.retryDelaySupplier = retryDelaySupplier;
    }

    protected void onActorStarting() {
        this.transport.replyTo(StreamTopics.ADD.topic(), MessageUtil::parseAddRequest, this::onAdd, Function.identity(), arg_0 -> ((ActorControl)this.actor).run(arg_0));
        this.transport.replyTo(StreamTopics.REMOVE.topic(), MessageUtil::parseRemoveRequest, this::onRemove, Function.identity(), arg_0 -> ((ActorControl)this.actor).run(arg_0));
        this.transport.replyTo(StreamTopics.REMOVE_ALL.topic(), Function.identity(), this::onRemoveAll, Function.identity(), arg_0 -> ((ActorControl)this.actor).run(arg_0));
    }

    protected void onActorClosing() {
        this.transport.unsubscribe(StreamTopics.ADD.topic());
        this.transport.unsubscribe(StreamTopics.REMOVE.topic());
        this.transport.unsubscribe(StreamTopics.REMOVE_ALL.topic());
        this.requestHandler.close();
    }

    public void removeAll(MemberId member) {
        this.actor.run(() -> this.requestHandler.removeAll(member));
    }

    private byte[] onAdd(MemberId sender, AddStreamRequest request) {
        this.requestHandler.add(sender, request);
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private byte[] onRemove(MemberId sender, RemoveStreamRequest request) {
        this.requestHandler.remove(sender, request);
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private byte[] onRemoveAll(MemberId sender, byte[] ignored) {
        this.requestHandler.removeAll(sender);
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public CompletableFuture<Void> restartStreams(MemberId receiver) {
        CompletableFuture<Void> completed = new CompletableFuture<Void>();
        this.sendRestartStreamsRequest(receiver, completed, 100L);
        return completed;
    }

    private void sendRestartStreamsRequest(MemberId receiver, CompletableFuture<Void> completed, long retryDelayMs) {
        try {
            this.sendRestartStreamsRequest(receiver).whenCompleteAsync((ok, error) -> this.onRestartStreamsResponse(receiver, (Throwable)error, completed, retryDelayMs), (Executor)this.actor);
        }
        catch (Exception e) {
            LOG.warn("Failed to restart streams for member '{}'", (Object)receiver, (Object)e);
        }
    }

    private CompletableFuture<Void> sendRestartStreamsRequest(MemberId receiver) {
        return this.transport.send(StreamTopics.RESTART_STREAMS.topic(), (Object)ArrayUtil.EMPTY_BYTE_ARRAY, Function.identity(), Function.identity(), receiver, REQUEST_TIMEOUT).thenApply(ok -> null);
    }

    private void onRestartStreamsResponse(MemberId receiver, Throwable error, CompletableFuture<Void> completed, long retryDelayMs) {
        if (error == null) {
            LOG.debug("Requested streams from client service member '{}'", (Object)receiver);
            completed.complete(null);
            return;
        }
        Throwable cause = error.getCause();
        if (cause instanceof MessagingException.NoSuchMemberException) {
            MessagingException.NoSuchMemberException e = (MessagingException.NoSuchMemberException)cause;
            LOG.trace("Failed to restart streams for member '{}', which has been removed from the\nmembership protocol; can be safely ignored.", (Object)receiver, (Object)e);
            completed.complete(null);
            return;
        }
        if (cause instanceof MessagingException.NoRemoteHandler) {
            MessagingException.NoRemoteHandler e = (MessagingException.NoRemoteHandler)cause;
            LOG.trace("Failed to restart streams for member '{}'; either it's not a client\nstream service, or it's still starting up. Can be safely ignored.", (Object)receiver, (Object)e);
            completed.complete(null);
            return;
        }
        if (cause instanceof MessagingException.RemoteHandlerFailure) {
            MessagingException.RemoteHandlerFailure e = (MessagingException.RemoteHandlerFailure)cause;
            LOG.warn("Failed to restart streams for member '{}'; unrecoverable error occurred on recipient\nside, will not retry.", (Object)receiver, (Object)e);
            completed.completeExceptionally((Throwable)e);
            return;
        }
        LOG.warn("Failed to restart streams for member '{}', retrying in {}ms", new Object[]{receiver, retryDelayMs, error});
        long nextRetryDelay = this.retryDelaySupplier.applyAsLong(retryDelayMs);
        this.actor.schedule(Duration.ofMillis(nextRetryDelay), () -> this.sendRestartStreamsRequest(receiver, completed, nextRetryDelay));
    }
}

