/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequestDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequestEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.util.SbeUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AddStreamRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final AddStreamRequestEncoder messageEncoder = new AddStreamRequestEncoder();
    private final AddStreamRequestDecoder messageDecoder = new AddStreamRequestDecoder();
    private final DirectBuffer streamType = new UnsafeBuffer();
    private UUID streamId;
    private final DirectBuffer metadataReader = new UnsafeBuffer();
    private BufferWriter metadataWriter = new DirectBufferWriter().wrap(this.metadataReader);

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.messageDecoder.wrapStreamType(this.streamType);
        this.messageDecoder.wrapMetadata(this.metadataReader);
        this.metadataWriter = new DirectBufferWriter().wrap(this.metadataReader);
        this.streamId = new UUID(this.messageDecoder.id().high(), this.messageDecoder.id().low());
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.messageEncoder.sbeBlockLength() + AddStreamRequestEncoder.streamTypeHeaderLength() + this.streamType.capacity() + AddStreamRequestEncoder.metadataHeaderLength() + this.metadataWriter.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).putStreamType(this.streamType, 0, this.streamType.capacity());
        SbeUtil.writeNested((BufferWriter)this.metadataWriter, (int)AddStreamRequestEncoder.metadataHeaderLength(), (MessageEncoderFlyweight)this.messageEncoder, (ByteOrder)AddStreamRequestEncoder.BYTE_ORDER);
        if (this.streamId != null) {
            this.messageEncoder.id().high(this.streamId.getMostSignificantBits()).low(this.streamId.getLeastSignificantBits());
        }
    }

    public DirectBuffer streamType() {
        return this.streamType;
    }

    public AddStreamRequest streamType(DirectBuffer streamType) {
        this.streamType.wrap(streamType);
        return this;
    }

    public DirectBuffer metadata() {
        return this.metadataReader;
    }

    public AddStreamRequest metadata(DirectBuffer metadata) {
        this.metadataReader.wrap(metadata);
        this.metadataWriter = new DirectBufferWriter().wrap(metadata);
        return this;
    }

    public AddStreamRequest metadata(BufferWriter metadataWriter) {
        this.metadataWriter = metadataWriter;
        this.metadataReader.wrap(0L, 0);
        return this;
    }

    public UUID streamId() {
        return this.streamId;
    }

    public AddStreamRequest streamId(UUID streamId) {
        this.streamId = streamId;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.streamType, this.metadataReader, this.streamId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddStreamRequest that = (AddStreamRequest)o;
        return this.streamType.equals(that.streamType) && this.metadataReader.equals(that.metadataReader) && Objects.equals(this.streamId, that.streamId);
    }

    public String toString() {
        return "AddStreamRequest{streamType=" + this.streamType + ", metadata=" + this.metadataReader + ", streamId=" + this.streamId + "}";
    }
}

