/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.file.DescriptorMetadataEncoder;
import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.SegmentDescriptorEncoder;
import io.camunda.zeebe.journal.util.ChecksumGenerator;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SegmentDescriptor {
    static final byte CUR_VERSION = 2;
    static final byte META_VERSION = 2;
    static final int VERSION_LENGTH = 1;
    private static final Logger LOG = LoggerFactory.getLogger(SegmentDescriptor.class);
    private final DescriptorMetadataEncoder metadataEncoder = new DescriptorMetadataEncoder();
    private final SegmentDescriptorEncoder segmentDescriptorEncoder = new SegmentDescriptorEncoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ChecksumGenerator checksumGen = new ChecksumGenerator();
    private final byte version;
    private final int actingSchemaVersion;
    private final long id;
    private final long index;
    private final int maxSegmentSize;
    private final int encodedLength;
    private long lastIndex;
    private int lastPosition;

    SegmentDescriptor(byte version, int actingSchemaVersion, long id, long index, int maxSegmentSize, long lastIndex, int lastPosition, int encodedLength) {
        this.version = version;
        this.actingSchemaVersion = actingSchemaVersion;
        this.id = id;
        this.index = index;
        this.maxSegmentSize = maxSegmentSize;
        this.lastIndex = lastIndex;
        this.lastPosition = lastPosition;
        this.encodedLength = encodedLength;
    }

    int length() {
        return this.encodedLength;
    }

    static int getEncodingLength() {
        return 57;
    }

    static Builder builder() {
        return new Builder();
    }

    long id() {
        return this.id;
    }

    long index() {
        return this.index;
    }

    int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    SegmentDescriptor copyTo(ByteBuffer buffer) {
        UnsafeBuffer directBuffer = new UnsafeBuffer();
        directBuffer.wrap(buffer);
        directBuffer.putByte(0, (byte)2);
        int descHeaderOffset = 17;
        this.segmentDescriptorEncoder.wrapAndApplyHeader((MutableDirectBuffer)directBuffer, 17, this.headerEncoder).id(this.id).index(this.index).maxSegmentSize(this.maxSegmentSize).lastIndex(this.lastIndex).lastPosition(this.lastPosition);
        long checksum = this.checksumGen.compute(buffer, 17, this.headerEncoder.encodedLength() + this.segmentDescriptorEncoder.encodedLength());
        this.metadataEncoder.wrapAndApplyHeader((MutableDirectBuffer)directBuffer, 1, this.headerEncoder).checksum(checksum);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.index, this.maxSegmentSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentDescriptor that = (SegmentDescriptor)o;
        return this.id == that.id && this.index == that.index && this.maxSegmentSize == that.maxSegmentSize;
    }

    public String toString() {
        return "SegmentDescriptor{id=" + this.id + ", index=" + this.index + ", maxSegmentSize=" + this.maxSegmentSize + ", lastIndex=" + this.lastIndex + ", lastPosition=" + this.lastPosition + "}";
    }

    int lastPosition() {
        return this.lastPosition;
    }

    void setLastPosition(int lastPosition) {
        this.lastPosition = lastPosition;
    }

    void setLastIndex(long lastIndex) {
        this.lastIndex = lastIndex;
    }

    void updateIfCurrentVersion(ByteBuffer buffer) {
        if (this.version >= 2 && this.actingSchemaVersion == this.segmentDescriptorEncoder.sbeSchemaVersion()) {
            this.copyTo(buffer);
        } else {
            LOG.trace("Segment descriptor version is {}, and sbe schema version is {}, which is different from current version {}, and current sbe schema version {}.Skipping update to the descriptor.", new Object[]{this.version, this.actingSchemaVersion, (byte)2, this.segmentDescriptorEncoder.sbeSchemaVersion()});
        }
    }

    long lastIndex() {
        return this.lastIndex;
    }

    static final class Builder {
        private long id;
        private long index;
        private int maxSegmentSize;

        Builder() {
        }

        Builder withId(long id) {
            Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (Object)"id must be positive");
            this.id = id;
            return this;
        }

        Builder withIndex(long index) {
            Preconditions.checkArgument((index > 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        Builder withMaxSegmentSize(int maxSegmentSize) {
            Preconditions.checkArgument((maxSegmentSize > 0 ? 1 : 0) != 0, (Object)"maxSegmentSize must be positive");
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        SegmentDescriptor build() {
            return new SegmentDescriptor(2, 2, this.id, this.index, this.maxSegmentSize, 0L, 0, SegmentDescriptor.getEncodingLength());
        }
    }
}

