/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.IndexInfo;
import io.camunda.zeebe.journal.file.JournalIndex;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class SparseJournalIndex
implements JournalIndex {
    private final int density;
    private final ConcurrentNavigableMap<Long, Integer> indexToPosition = new ConcurrentSkipListMap<Long, Integer>();
    private final ConcurrentNavigableMap<Long, Long> asqnToIndex = new ConcurrentSkipListMap<Long, Long>();
    private final ConcurrentNavigableMap<Long, Long> indexToAsqn = new ConcurrentSkipListMap<Long, Long>();

    SparseJournalIndex(int density) {
        this.density = density;
    }

    @Override
    public void index(JournalRecord indexedEntry, int position) {
        long index = indexedEntry.index();
        if (index % (long)this.density == 0L) {
            this.indexToPosition.put(index, position);
            long asqn = indexedEntry.asqn();
            if (asqn != -1L) {
                this.asqnToIndex.put(asqn, index);
                this.indexToAsqn.put(index, asqn);
            }
        }
    }

    @Override
    public IndexInfo lookup(long index) {
        Map.Entry entry = this.indexToPosition.floorEntry(index);
        return entry != null ? new IndexInfo(entry.getKey(), (Integer)entry.getValue()) : null;
    }

    @Override
    public Long lookupAsqn(long asqn) {
        return this.lookupAsqn(asqn, Long.MAX_VALUE);
    }

    @Override
    public Long lookupAsqn(long asqn, long indexUpperBound) {
        Map.Entry entry = this.asqnToIndex.floorEntry(asqn);
        if (entry != null) {
            if ((Long)entry.getValue() <= indexUpperBound) {
                return (Long)entry.getValue();
            }
            return this.indexToAsqn.floorKey(indexUpperBound);
        }
        return null;
    }

    @Override
    public void deleteAfter(long index) {
        this.indexToPosition.tailMap((Object)index, false).clear();
        Map.Entry asqnEntryToDelete = this.indexToAsqn.ceilingEntry(index);
        if (asqnEntryToDelete != null) {
            Long asqnToDelete = (Long)asqnEntryToDelete.getValue();
            this.indexToAsqn.tailMap((Object)index, false).clear();
            boolean include = asqnEntryToDelete.getKey() > index;
            this.asqnToIndex.tailMap((Object)asqnToDelete, include).clear();
        }
    }

    @Override
    public void deleteUntil(long index) {
        this.indexToPosition.headMap((Object)index, false).clear();
        Map.Entry asqnEntryToDelete = this.indexToAsqn.floorEntry(index);
        if (asqnEntryToDelete != null) {
            Long asqnToDelete = (Long)asqnEntryToDelete.getValue();
            this.indexToAsqn.headMap((Object)index, false).clear();
            this.asqnToIndex.headMap((Object)asqnToDelete, false).clear();
        }
    }

    @Override
    public void clear() {
        this.indexToPosition.clear();
        this.indexToAsqn.clear();
        this.asqnToIndex.clear();
    }

    @Override
    public boolean hasIndexed(long index) {
        IndexInfo indexInfo = this.lookup(index);
        if (indexInfo == null) {
            return false;
        }
        return indexInfo.index() > index - (long)this.density;
    }
}

