/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.ConnectionFilter;
import com.auth0.json.mgmt.Connection;
import com.auth0.json.mgmt.ConnectionsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ConnectionsEntity
extends BaseManagementEntity {
    ConnectionsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<ConnectionsPage> listAll(ConnectionFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/connections");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<ConnectionsPage> request = new CustomRequest<ConnectionsPage>(this.client, url, "GET", new TypeReference<ConnectionsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    @Deprecated
    public Request<List<Connection>> list(ConnectionFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/connections");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if (e.getKey().equalsIgnoreCase("include_totals")) continue;
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<List<Connection>> request = new CustomRequest<List<Connection>>(this.client, url, "GET", new TypeReference<List<Connection>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Connection> get(String connectionId, ConnectionFilter filter) {
        Asserts.assertNotNull(connectionId, "connection id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<Connection> request = new CustomRequest<Connection>(this.client, url, "GET", new TypeReference<Connection>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Connection> create(Connection connection) {
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").build().toString();
        CustomRequest<Connection> request = new CustomRequest<Connection>(this.client, url, "POST", new TypeReference<Connection>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(connection);
        return request;
    }

    public Request<Void> delete(String connectionId) {
        Asserts.assertNotNull(connectionId, "connection id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Connection> update(String connectionId, Connection connection) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).build().toString();
        CustomRequest<Connection> request = new CustomRequest<Connection>(this.client, url, "PATCH", new TypeReference<Connection>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(connection);
        return request;
    }

    public Request<Void> deleteUser(String connectionId, String email) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(email, "email");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/connections").addPathSegment(connectionId).addPathSegment("users").addQueryParameter("email", email).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

