/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.net.Telemetry;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TelemetryInterceptor
implements Interceptor {
    private Telemetry telemetry;
    private boolean enabled;

    public TelemetryInterceptor() {
        this(new Telemetry("auth0-java", Telemetry.class.getPackage().getImplementationVersion()));
    }

    TelemetryInterceptor(Telemetry telemetry) {
        this.telemetry = telemetry;
        this.enabled = true;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (!this.enabled) {
            return chain.proceed(chain.request());
        }
        Request request = chain.request().newBuilder().addHeader("Auth0-Client", this.telemetry.getValue()).build();
        return chain.proceed(request);
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

