/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.keycloak;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AbstractAuthentication;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.authentication.exception.CodeExchangeException;
import io.camunda.identity.sdk.impl.keycloak.KeycloakAuthorizeUriBuilder;
import io.camunda.identity.sdk.impl.keycloak.dto.AccessTokenDto;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.ClientTokenRequest;
import io.camunda.identity.sdk.impl.rest.request.ExchangeAuthCodeRequest;
import io.camunda.identity.sdk.impl.rest.request.RenewTokenRequest;
import io.camunda.identity.sdk.impl.rest.request.RevokeTokenRequest;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class KeycloakAuthentication
extends AbstractAuthentication {
    public static final String AUTHORIZE_PATH = "/protocol/openid-connect/auth";
    public static final String TOKEN_PATH = "/protocol/openid-connect/token";
    public static final String LOGOUT_PATH = "/protocol/openid-connect/logout";
    public static final String JWKS_PATH = "/protocol/openid-connect/certs";
    private final RestClient restClient;
    private JwkProvider jwkProvider;

    public KeycloakAuthentication(IdentityConfiguration configuration, RestClient restClient) {
        super(configuration);
        this.restClient = restClient;
    }

    @Override
    public AuthorizeUriBuilder authorizeUriBuilder(String redirectUri) {
        return new KeycloakAuthorizeUriBuilder(this.configuration, redirectUri);
    }

    @Override
    public Tokens exchangeAuthCode(AuthCodeDto authCodeDto, String redirectUri) throws CodeExchangeException {
        Validate.notNull((Object)authCodeDto, (String)"authCodeDto must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"redirectUri must not be null", (Object[])new Object[0]);
        if (authCodeDto.getError() != null && !authCodeDto.getError().isBlank()) {
            throw new CodeExchangeException(authCodeDto.getError());
        }
        Validate.notEmpty((CharSequence)authCodeDto.getCode(), (String)"code must not be null", (Object[])new Object[0]);
        ExchangeAuthCodeRequest request = new ExchangeAuthCodeRequest(this.configuration, redirectUri, authCodeDto.getCode());
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    protected Tokens requestFreshToken(String audience) {
        ClientTokenRequest request = new ClientTokenRequest(this.configuration, audience);
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    public Tokens renewToken(String refreshToken) {
        Validate.notEmpty((CharSequence)refreshToken, (String)"refreshToken can not be empty", (Object[])new Object[0]);
        RenewTokenRequest request = new RenewTokenRequest(this.configuration, refreshToken);
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    public void revokeToken(String refreshToken) {
        Validate.notEmpty((CharSequence)refreshToken, (String)"refreshToken can not be empty", (Object[])new Object[0]);
        RevokeTokenRequest request = new RevokeTokenRequest(this.configuration, refreshToken);
        this.restClient.request(request);
    }

    @Override
    public List<String> getPermissions(DecodedJWT token, String audience) {
        if (audience == null) {
            return Collections.emptyList();
        }
        return token.getClaim("permissions").asMap().getOrDefault(audience, new ArrayList());
    }

    @Override
    public boolean isM2MToken(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return !decodedJwt.getClaim("client_id").isMissing();
    }

    @Override
    public String getClientId(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("client_id").asString();
    }

    @Override
    protected Map<String, Set<String>> getAssignedOrganizations(DecodedJWT token) {
        return Collections.emptyMap();
    }

    @Override
    protected JwkProvider jwkProvider() {
        if (this.jwkProvider == null) {
            try {
                String jwksPath = UrlUtility.combinePaths(this.configuration.getIssuerBackendUrl(), JWKS_PATH);
                this.jwkProvider = new JwkProviderBuilder(new URL(jwksPath)).cached(5L, 7L, TimeUnit.DAYS).build();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("invalid issuer url", e);
            }
        }
        return this.jwkProvider;
    }

    private Tokens fromAccessTokenDto(AccessTokenDto dto) {
        return new Tokens(dto.getAccessToken(), dto.getRefreshToken(), dto.getExpiresIn(), dto.getScope(), dto.getTokenType());
    }
}

