/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.PartitionRaftListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.jobstream.JobStreamService;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.partitioning.topology.ClusterTopologyService;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BrokerStartupContextImpl
implements BrokerStartupContext {
    private final BrokerInfo brokerInfo;
    private final BrokerCfg configuration;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorSchedulingService actorScheduler;
    private final BrokerHealthCheckService healthCheckService;
    private final ExporterRepository exporterRepository;
    private final ClusterServicesImpl clusterServices;
    private final List<PartitionListener> partitionListeners = new ArrayList<PartitionListener>();
    private final List<PartitionRaftListener> partitionRaftListeners = new ArrayList<PartitionRaftListener>();
    private ConcurrencyControl concurrencyControl;
    private DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private AtomixServerTransport gatewayBrokerTransport;
    private ManagedMessagingService commandApiMessagingService;
    private CommandApiServiceImpl commandApiService;
    private AdminApiRequestHandler adminApiService;
    private EmbeddedGatewayService embeddedGatewayService;
    private PartitionManagerImpl partitionManager;
    private BrokerAdminServiceImpl brokerAdminService;
    private JobStreamService jobStreamService;
    private ClusterTopologyService clusterTopologyService;

    public BrokerStartupContextImpl(BrokerInfo brokerInfo, BrokerCfg configuration, SpringBrokerBridge springBrokerBridge, ActorSchedulingService actorScheduler, BrokerHealthCheckService healthCheckService, ExporterRepository exporterRepository, ClusterServicesImpl clusterServices, List<PartitionListener> additionalPartitionListeners) {
        this.brokerInfo = Objects.requireNonNull(brokerInfo);
        this.configuration = Objects.requireNonNull(configuration);
        this.springBrokerBridge = Objects.requireNonNull(springBrokerBridge);
        this.actorScheduler = Objects.requireNonNull(actorScheduler);
        this.healthCheckService = Objects.requireNonNull(healthCheckService);
        this.exporterRepository = Objects.requireNonNull(exporterRepository);
        this.clusterServices = Objects.requireNonNull(clusterServices);
        this.partitionListeners.addAll(additionalPartitionListeners);
    }

    public String toString() {
        return "BrokerStartupContextImpl{broker=" + this.brokerInfo.getNodeId() + "}";
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    @Override
    public BrokerCfg getBrokerConfiguration() {
        return this.configuration;
    }

    @Override
    public SpringBrokerBridge getSpringBrokerBridge() {
        return this.springBrokerBridge;
    }

    @Override
    public ActorSchedulingService getActorSchedulingService() {
        return this.actorScheduler;
    }

    @Override
    public ConcurrencyControl getConcurrencyControl() {
        return this.concurrencyControl;
    }

    public void setConcurrencyControl(ConcurrencyControl concurrencyControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
    }

    @Override
    public BrokerHealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    @Override
    public void addPartitionListener(PartitionListener listener) {
        this.partitionListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public void removePartitionListener(PartitionListener listener) {
        this.partitionListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public void addPartitionRaftListener(PartitionRaftListener listener) {
        this.partitionRaftListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public void removePartitionRaftListener(PartitionRaftListener listener) {
        this.partitionRaftListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public List<PartitionListener> getPartitionListeners() {
        return Collections.unmodifiableList(this.partitionListeners);
    }

    @Override
    public List<PartitionRaftListener> getPartitionRaftListeners() {
        return Collections.unmodifiableList(this.partitionRaftListeners);
    }

    @Override
    public ClusterServicesImpl getClusterServices() {
        return this.clusterServices;
    }

    @Override
    public CommandApiServiceImpl getCommandApiService() {
        return this.commandApiService;
    }

    @Override
    public void setCommandApiService(CommandApiServiceImpl commandApiService) {
        this.commandApiService = commandApiService;
    }

    @Override
    public AdminApiRequestHandler getAdminApiService() {
        return this.adminApiService;
    }

    @Override
    public void setAdminApiService(AdminApiRequestHandler adminApiService) {
        this.adminApiService = adminApiService;
    }

    @Override
    public AtomixServerTransport getGatewayBrokerTransport() {
        return this.gatewayBrokerTransport;
    }

    @Override
    public void setGatewayBrokerTransport(AtomixServerTransport gatewayBrokerTransport) {
        this.gatewayBrokerTransport = gatewayBrokerTransport;
    }

    @Override
    public ManagedMessagingService getApiMessagingService() {
        return this.commandApiMessagingService;
    }

    @Override
    public void setApiMessagingService(ManagedMessagingService commandApiMessagingService) {
        this.commandApiMessagingService = commandApiMessagingService;
    }

    @Override
    public EmbeddedGatewayService getEmbeddedGatewayService() {
        return this.embeddedGatewayService;
    }

    @Override
    public void setEmbeddedGatewayService(EmbeddedGatewayService embeddedGatewayService) {
        this.embeddedGatewayService = embeddedGatewayService;
    }

    @Override
    public DiskSpaceUsageMonitor getDiskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    @Override
    public void setDiskSpaceUsageMonitor(DiskSpaceUsageMonitor diskSpaceUsageMonitor) {
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
    }

    @Override
    public ExporterRepository getExporterRepository() {
        return this.exporterRepository;
    }

    @Override
    public PartitionManagerImpl getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public void setPartitionManager(PartitionManagerImpl partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Override
    public BrokerAdminServiceImpl getBrokerAdminService() {
        return this.brokerAdminService;
    }

    @Override
    public void setBrokerAdminService(BrokerAdminServiceImpl brokerAdminService) {
        this.brokerAdminService = brokerAdminService;
    }

    @Override
    public JobStreamService getJobStreamService() {
        return this.jobStreamService;
    }

    @Override
    public void setJobStreamService(JobStreamService jobStreamService) {
        this.jobStreamService = jobStreamService;
    }

    @Override
    public ClusterTopologyService getClusterTopology() {
        return this.clusterTopologyService;
    }

    @Override
    public void setClusterTopology(ClusterTopologyService clusterTopologyService) {
        this.clusterTopologyService = clusterTopologyService;
    }
}

