/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;

class ClusterServicesStep
extends AbstractBrokerStartupStep {
    ClusterServicesStep() {
    }

    public String getName() {
        return "Cluster Services";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        brokerStartupContext.getClusterServices().start().whenComplete((ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
            } else {
                startupFuture.complete((Object)brokerStartupContext);
            }
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        ClusterServicesImpl clusterServices = brokerShutdownContext.getClusterServices();
        if (clusterServices == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        clusterServices.stop().whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                shutdownFuture.complete((Object)brokerShutdownContext);
            }
        });
    }
}

