/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;

final class PartitionManagerStep
extends AbstractBrokerStartupStep {
    PartitionManagerStep() {
    }

    public String getName() {
        return "Partition Manager";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(brokerStartupContext.getConcurrencyControl(), brokerStartupContext.getActorSchedulingService(), brokerStartupContext.getBrokerConfiguration(), brokerStartupContext.getBrokerInfo(), brokerStartupContext.getClusterServices(), brokerStartupContext.getHealthCheckService(), brokerStartupContext.getDiskSpaceUsageMonitor(), brokerStartupContext.getPartitionListeners(), brokerStartupContext.getPartitionRaftListeners(), brokerStartupContext.getCommandApiService(), brokerStartupContext.getExporterRepository(), brokerStartupContext.getGatewayBrokerTransport(), brokerStartupContext.getJobStreamService().jobStreamer(), brokerStartupContext.getClusterTopology().getPartitionDistribution());
        concurrencyControl.run(() -> {
            try {
                partitionManager.start();
                brokerStartupContext.setPartitionManager(partitionManager);
                brokerStartupContext.getClusterTopology().registerPartitionChangeExecutor(partitionManager);
                startupFuture.complete((Object)brokerStartupContext);
            }
            catch (Exception e) {
                startupFuture.completeExceptionally((Throwable)e);
            }
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        PartitionManagerImpl partitionManager = brokerShutdownContext.getPartitionManager();
        if (partitionManager == null) {
            shutdownFuture.complete(null);
            return;
        }
        brokerShutdownContext.getClusterTopology().removePartitionChangeExecutor();
        concurrencyControl.runOnCompletion(partitionManager.stop(), (ok, error) -> {
            brokerShutdownContext.setPartitionManager(null);
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                shutdownFuture.complete((Object)brokerShutdownContext);
            }
        });
    }
}

