/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.prometheus.client.Gauge;
import java.util.function.IntConsumer;

public interface ScheduledCommandCacheMetrics {
    public IntConsumer forIntent(Intent var1);

    public static class BoundedCommandCacheMetrics
    implements ScheduledCommandCacheMetrics {
        private static final Gauge SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).subsystem("stream_processor")).name("scheduled_command_cache_size")).labelNames(new String[]{"partitionId", "intent"})).help("Reports the size of each bounded cache per partition and intent")).register();
        private final String partitionId;

        public BoundedCommandCacheMetrics(int partitionId) {
            this.partitionId = String.valueOf(partitionId);
        }

        @Override
        public IntConsumer forIntent(Intent intent) {
            String intentLabelValue = intent.getClass().getSimpleName() + "." + intent.name();
            return arg_0 -> ((Gauge.Child)((Gauge.Child)SIZE.labels(new String[]{this.partitionId, intentLabelValue}))).set(arg_0);
        }
    }
}

