/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.util.ReflectUtil;
import java.util.Map;

public record ExporterConfiguration(String id, Map<String, Object> arguments) implements Configuration
{
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES})).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> T instantiate(Class<T> configClass) {
        if (this.arguments != null) {
            return (T)MAPPER.convertValue(this.arguments, configClass);
        }
        return (T)ReflectUtil.newInstance(configClass);
    }
}

