/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongArrayList;

final class TtlKeyCache {
    private static final int DEFAULT_MAX_CAPACITY = 10000;
    private static final long DEFAULT_NULL_VALUE = -1L;
    private final Long2LongHashMap keyToTimestamp;
    private final NavigableMap<Long, LongArrayList> timestampToKeys = new TreeMap<Long, LongArrayList>();
    private final int maxCapacity;

    TtlKeyCache() {
        this(10000);
    }

    TtlKeyCache(int maxCapacity) {
        this(maxCapacity, -1L);
    }

    TtlKeyCache(long nullValue) {
        this(10000, nullValue);
    }

    TtlKeyCache(int maxCapacity, long nullValue) {
        this.maxCapacity = maxCapacity;
        this.keyToTimestamp = new Long2LongHashMap(nullValue);
    }

    void store(long key, long timestamp) {
        if (this.keyToTimestamp.size() >= this.maxCapacity) {
            this.evictOldestKey();
        }
        this.keyToTimestamp.put(key, timestamp);
        this.timestampToKeys.computeIfAbsent(timestamp, ignored -> new LongArrayList()).add(Long.valueOf(key));
    }

    long remove(long key) {
        long timestamp = this.keyToTimestamp.remove(key);
        LongArrayList keys = (LongArrayList)this.timestampToKeys.get(timestamp);
        if (keys != null) {
            keys.remove((Object)key);
            if (keys.isEmpty()) {
                this.timestampToKeys.remove(timestamp);
            }
        }
        return timestamp;
    }

    void cleanup(long timestamp) {
        SortedMap<Long, LongArrayList> outOfScopeInstances = this.timestampToKeys.headMap(timestamp);
        for (LongArrayList keys : outOfScopeInstances.values()) {
            keys.forEach(arg_0 -> ((Long2LongHashMap)this.keyToTimestamp).remove(arg_0));
        }
        outOfScopeInstances.clear();
    }

    boolean isEmpty() {
        return this.keyToTimestamp.isEmpty() && this.timestampToKeys.isEmpty();
    }

    void clear() {
        this.keyToTimestamp.clear();
        this.timestampToKeys.clear();
    }

    int size() {
        return this.keyToTimestamp.size();
    }

    private void evictOldestKey() {
        Long evictedKey;
        Map.Entry<Long, LongArrayList> oldestEntries = this.timestampToKeys.firstEntry();
        if (oldestEntries != null && (evictedKey = oldestEntries.getValue().remove(0)) != null) {
            this.remove(evictedKey);
        }
    }
}

