/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.stream.ExporterStateDistributeMessage;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class ExporterStateDistributionService
implements AutoCloseable {
    private static final Logger PERIODIC_LOGGER = new ThrottledLogger(Loggers.EXPORTER_LOGGER, Duration.ofSeconds(60L));
    private final PartitionMessagingService partitionMessagingService;
    private final String exporterStateTopic;
    private final BiConsumer<String, ExporterStateDistributeMessage.ExporterStateEntry> exporterStateConsumer;

    public ExporterStateDistributionService(BiConsumer<String, ExporterStateDistributeMessage.ExporterStateEntry> exporterStateConsumer, PartitionMessagingService partitionMessagingService, String exporterStateTopic) {
        this.exporterStateConsumer = exporterStateConsumer;
        this.partitionMessagingService = partitionMessagingService;
        this.exporterStateTopic = exporterStateTopic;
    }

    public void subscribeForExporterState(Executor executor) {
        this.partitionMessagingService.subscribe(this.exporterStateTopic, this::storeExporterState, executor);
    }

    private void storeExporterState(ByteBuffer byteBuffer) {
        UnsafeBuffer readBuffer = new UnsafeBuffer(byteBuffer);
        ExporterStateDistributeMessage distributeMessage = new ExporterStateDistributeMessage();
        distributeMessage.wrap((DirectBuffer)readBuffer, 0, readBuffer.capacity());
        Map<String, ExporterStateDistributeMessage.ExporterStateEntry> exporterState = distributeMessage.getExporterState();
        Loggers.EXPORTER_LOGGER.trace("Received new exporter state {}", exporterState);
        PERIODIC_LOGGER.debug("Current exporter state {}", exporterState);
        exporterState.forEach(this.exporterStateConsumer);
    }

    public void distributeExporterState(ExporterStateDistributeMessage distributeMessage) {
        this.partitionMessagingService.broadcast(this.exporterStateTopic, distributeMessage.toByteBuffer());
    }

    @Override
    public void close() {
        this.partitionMessagingService.unsubscribe(this.exporterStateTopic);
    }
}

