/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup;

import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.storage.log.DelayedFlusher;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.concurrent.Scheduler;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.raft.ZeebeEntryValidator;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.RaftCfg;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;

public final class RaftPartitionFactory {
    public static final String GROUP_NAME = "raft-partition";
    private final BrokerCfg brokerCfg;

    public RaftPartitionFactory(BrokerCfg brokerCfg) {
        this.brokerCfg = brokerCfg;
    }

    public RaftPartition createRaftPartition(PartitionMetadata partitionMetadata) {
        Path partitionDirectory = Paths.get(this.brokerCfg.getData().getDirectory(), new String[0]).resolve(GROUP_NAME).resolve("partitions").resolve(((Integer)partitionMetadata.id().id()).toString());
        try {
            FileUtil.ensureDirectoryExists((Path)partitionDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.createRaftPartition(partitionMetadata, partitionDirectory);
    }

    public RaftPartition createRaftPartition(PartitionMetadata partitionMetadata, Path partitionDirectory) {
        RaftStorageConfig storageConfig = new RaftStorageConfig();
        RaftPartitionConfig partitionConfig = new RaftPartitionConfig();
        long maxMessageSize = this.brokerCfg.getNetwork().getMaxMessageSizeInBytes();
        long segmentSize = this.brokerCfg.getData().getLogSegmentSizeInBytes();
        if (segmentSize < maxMessageSize) {
            throw new IllegalArgumentException(String.format("Expected the raft segment size greater than the max message size of %s, but was %s.", maxMessageSize, segmentSize));
        }
        storageConfig.setSegmentSize(segmentSize);
        storageConfig.setFlusherFactory(this.createFlusherFactory(this.brokerCfg.getCluster().getRaft().getFlush(), this.brokerCfg.getExperimental()));
        storageConfig.setFreeDiskSpace(this.brokerCfg.getData().getDisk().getFreeSpace().getReplication().toBytes());
        storageConfig.setJournalIndexDensity(this.brokerCfg.getData().getLogIndexDensity());
        storageConfig.setPreallocateSegmentFiles(this.brokerCfg.getExperimental().getRaft().isPreallocateSegmentFiles());
        partitionConfig.setStorageConfig(storageConfig);
        partitionConfig.setEntryValidator((EntryValidator)new ZeebeEntryValidator());
        partitionConfig.setMaxAppendBatchSize((int)this.brokerCfg.getExperimental().getMaxAppendBatchSizeInBytes());
        partitionConfig.setMaxAppendsPerFollower(this.brokerCfg.getExperimental().getMaxAppendsPerFollower());
        partitionConfig.setPriorityElectionEnabled(this.brokerCfg.getCluster().getRaft().isEnablePriorityElection());
        partitionConfig.setElectionTimeout(this.brokerCfg.getCluster().getElectionTimeout());
        partitionConfig.setHeartbeatInterval(this.brokerCfg.getCluster().getHeartbeatInterval());
        partitionConfig.setRequestTimeout(this.brokerCfg.getExperimental().getRaft().getRequestTimeout());
        partitionConfig.setSnapshotRequestTimeout(this.brokerCfg.getExperimental().getRaft().getSnapshotRequestTimeout());
        partitionConfig.setMaxQuorumResponseTimeout(this.brokerCfg.getExperimental().getRaft().getMaxQuorumResponseTimeout());
        partitionConfig.setMinStepDownFailureCount(this.brokerCfg.getExperimental().getRaft().getMinStepDownFailureCount());
        partitionConfig.setPreferSnapshotReplicationThreshold(this.brokerCfg.getExperimental().getRaft().getPreferSnapshotReplicationThreshold());
        return new RaftPartition(partitionMetadata, partitionConfig, partitionDirectory.toFile());
    }

    private RaftLogFlusher.Factory createFlusherFactory(RaftCfg.FlushConfig config, ExperimentalCfg experimental) {
        if (experimental.isDisableExplicitRaftFlush()) {
            return this.createFlusherFactory(new RaftCfg.FlushConfig(false, Duration.ZERO));
        }
        return this.createFlusherFactory(config);
    }

    private RaftLogFlusher.Factory createFlusherFactory(RaftCfg.FlushConfig config) {
        if (config.enabled()) {
            Duration delayTime = config.delayTime();
            if (delayTime.isZero()) {
                return RaftLogFlusher.Factory::direct;
            }
            return threadFactory -> new DelayedFlusher((Scheduler)threadFactory.createContext(), delayTime);
        }
        Loggers.RAFT.warn("Explicit Raft flush is disabled. Data will be flushed to disk only before a snapshot is\ntaken. This is generally unsafe and could lead to data loss or corruption. Make sure to\nread the documentation regarding this feature.");
        return RaftLogFlusher.Factory::noop;
    }
}

