/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;

public final class SnapshotStoreStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Snapshot Store";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        FileBasedSnapshotStore snapshotStore = new FileBasedSnapshotStore(((Integer)context.partitionMetadata().id().id()).intValue(), context.partitionDirectory());
        ActorFuture submit = context.schedulingService().submitActor((Actor)snapshotStore);
        context.concurrencyControl().runOnCompletion(submit, (ignored, failure) -> {
            if (failure == null) {
                context.snapshotStore(snapshotStore);
                result.complete((Object)context);
            } else {
                result.completeExceptionally(failure);
            }
        });
        return result;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        FileBasedSnapshotStore snapshotStore = context.snapshotStore();
        if (snapshotStore == null) {
            result.complete((Object)context);
            return result;
        }
        ActorFuture close = snapshotStore.closeAsync();
        context.concurrencyControl().runOnCompletion(close, (ignored, failure) -> {
            if (failure == null) {
                result.complete((Object)context.snapshotStore(null));
            } else {
                result.completeExceptionally(failure);
            }
        });
        return result;
    }
}

