/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.management;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.management.PartitionStatus;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.stereotype.Component;

@Component
@Endpoint(id="partitions")
public class BrokerAdminServiceEndpoint {
    @Autowired
    private SpringBrokerBridge springBrokerBridge;
    private final Map<String, Runnable> operations = new HashMap<String, Runnable>();

    public BrokerAdminServiceEndpoint() {
        this.operations.put("pauseProcessing", this::pauseProcessing);
        this.operations.put("resumeProcessing", this::resumeProcessing);
        this.operations.put("takeSnapshot", this::takeSnapshot);
        this.operations.put("prepareUpgrade", this::prepareUpgrade);
        this.operations.put("pauseExporting", this::pauseExporting);
        this.operations.put("resumeExporting", this::resumeExporting);
    }

    @WriteOperation
    public Map<Integer, PartitionStatus> trigger(@Selector String operation) {
        Runnable runnable = this.operations.get(operation);
        if (runnable != null) {
            runnable.run();
            return this.partitionStatus();
        }
        return null;
    }

    private Map<Integer, PartitionStatus> pauseProcessing() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::pauseStreamProcessing);
        return this.partitionStatus();
    }

    private Map<Integer, PartitionStatus> resumeProcessing() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::resumeStreamProcessing);
        return this.partitionStatus();
    }

    private Map<Integer, PartitionStatus> pauseExporting() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::pauseExporting);
        return this.partitionStatus();
    }

    private Map<Integer, PartitionStatus> resumeExporting() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::resumeExporting);
        return this.partitionStatus();
    }

    private Map<Integer, PartitionStatus> takeSnapshot() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::takeSnapshot);
        return this.partitionStatus();
    }

    private Map<Integer, PartitionStatus> prepareUpgrade() {
        this.springBrokerBridge.getAdminService().ifPresent(BrokerAdminService::prepareForUpgrade);
        return this.partitionStatus();
    }

    @ReadOperation
    public Map<Integer, PartitionStatus> partitionStatus() {
        return this.springBrokerBridge.getAdminService().map(BrokerAdminService::getPartitionStatus).orElse(Map.of());
    }
}

