/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;

public final class AdminApiRequestHandlerStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        AdminApiRequestHandler adminApiService;
        if (!targetRole.active() && (adminApiService = context.getAdminApiService()) != null) {
            context.setAdminApiRequestHandler(null);
            return adminApiService.closeAsync();
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (!targetRole.active() || context.getAdminApiService() != null) {
            return CompletableActorFuture.completed(null);
        }
        ConcurrencyControl concurrencyControl = context.getConcurrencyControl();
        ActorSchedulingService schedulingService = context.getActorSchedulingService();
        AtomixServerTransport transport = context.getGatewayBrokerTransport();
        AdminApiRequestHandler handler = new AdminApiRequestHandler(transport, context.getAdminAccess(), context.getRaftPartition());
        ActorFuture submitFuture = schedulingService.submitActor((Actor)handler);
        concurrencyControl.runOnCompletion(submitFuture, (ok, error) -> {
            if (error == null) {
                context.setAdminApiRequestHandler(handler);
            }
        });
        return submitFuture;
    }

    @Override
    public String getName() {
        return "Admin API";
    }
}

