/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.stream.impl.state.DbKeyGenerator;

public class MigrationTransitionStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (targetRole == RaftServer.Role.INACTIVE) {
            return CompletableActorFuture.completed(null);
        }
        TransientPendingSubscriptionState transientMessageSubscriptionState = new TransientPendingSubscriptionState();
        TransientPendingSubscriptionState transientProcessMessageSubscriptionState = new TransientPendingSubscriptionState();
        ZeebeDb zeebeDb = context.getZeebeDb();
        TransactionContext zeebeDbContext = zeebeDb.createContext();
        ProcessingDbState processingState = new ProcessingDbState(context.getPartitionId(), zeebeDb, zeebeDbContext, (KeyGenerator)new DbKeyGenerator(context.getPartitionId(), zeebeDb, zeebeDbContext), transientMessageSubscriptionState, transientProcessMessageSubscriptionState, context.getBrokerCfg().getExperimental().getEngine().createEngineConfiguration());
        DbMigratorImpl dbMigrator = new DbMigratorImpl((MutableProcessingState)processingState);
        try {
            dbMigrator.runMigrations();
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "Migration";
    }
}

