/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;

public enum IncidentIntent implements ProcessInstanceRelatedIntent
{
    CREATED(0),
    RESOLVE(1, false),
    RESOLVED(2);

    private final short value;
    private final boolean shouldBanInstance;

    private IncidentIntent(short value) {
        this(value, true);
    }

    private IncidentIntent(short value, boolean shouldBanInstance) {
        this.value = value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return RESOLVE;
            }
            case 2: {
                return RESOLVED;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this) {
            case CREATED: 
            case RESOLVED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }
}

