/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public final class BrokerClientComponent {
    final GatewayCfg config;
    final AtomixCluster atomixCluster;
    final ActorScheduler actorScheduler;

    @Autowired
    public BrokerClientComponent(GatewayCfg config, AtomixCluster atomixCluster, ActorScheduler actorScheduler) {
        this.config = config;
        this.atomixCluster = atomixCluster;
        this.actorScheduler = actorScheduler;
    }

    @Bean(destroyMethod="close")
    public BrokerClient brokerClient() {
        return new BrokerClientImpl(this.config.getCluster().getRequestTimeout(), this.atomixCluster.getMessagingService(), this.atomixCluster.getMembershipService(), this.atomixCluster.getEventService(), this.atomixCluster.getCommunicationService(), (ActorSchedulingService)this.actorScheduler);
    }
}

