/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management.openapi.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.shared.management.openapi.models.StateCode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="PartitionBackupInfo", description="Detailed info of the backup for a given partition.")
public class PartitionBackupInfo {
    private Integer partitionId;
    private StateCode state;
    private String failureReason;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime lastUpdatedAt;
    private String snapshotId;
    private Long checkpointPosition;
    private Integer brokerId;
    private String brokerVersion;

    public PartitionBackupInfo() {
    }

    public PartitionBackupInfo(Integer partitionId, StateCode state) {
        this.partitionId = partitionId;
        this.state = state;
    }

    public PartitionBackupInfo partitionId(Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Min(value=1L)
    @Schema(name="partitionId", accessMode=Schema.AccessMode.READ_ONLY, example="3", description="The ID of a partition. This is always a positive number greater than or equal to 1. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="partitionId")
    public @Min(value=1L) Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public PartitionBackupInfo state(StateCode state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="state")
    public StateCode getState() {
        return this.state;
    }

    public void setState(StateCode state) {
        this.state = state;
    }

    public PartitionBackupInfo failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Schema(name="failureReason", example="", description="Failure reason if stats is 'FAILED'", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="failureReason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public PartitionBackupInfo createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Valid
    @Schema(name="createdAt", accessMode=Schema.AccessMode.READ_ONLY, example="2022-09-15T13:10:38.176514094Z", description="The timestamp at which the backup was started on this partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PartitionBackupInfo lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @Valid
    @Schema(name="lastUpdatedAt", accessMode=Schema.AccessMode.READ_ONLY, example="2022-09-15T13:10:38.176514094Z", description="The timestamp at which the backup was last updated on this partition, e.g. changed state from IN_PROGRESS to COMPLETED. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lastUpdatedAt")
    public OffsetDateTime getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public PartitionBackupInfo snapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    @Schema(name="snapshotId", accessMode=Schema.AccessMode.READ_ONLY, example="238632143-55-690906332-690905294", description="The ID of the snapshot which is included in this backup.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="snapshotId")
    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public PartitionBackupInfo checkpointPosition(Long checkpointPosition) {
        this.checkpointPosition = checkpointPosition;
        return this;
    }

    @Schema(name="checkpointPosition", accessMode=Schema.AccessMode.READ_ONLY, example="10", description="The position of the checkpoint for this backup.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="checkpointPosition")
    public Long getCheckpointPosition() {
        return this.checkpointPosition;
    }

    public void setCheckpointPosition(Long checkpointPosition) {
        this.checkpointPosition = checkpointPosition;
    }

    public PartitionBackupInfo brokerId(Integer brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    @Min(value=0L)
    @Schema(name="brokerId", accessMode=Schema.AccessMode.READ_ONLY, example="0", description="The ID of the broker from which the backup was taken for this partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokerId")
    public @Min(value=0L) Integer getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(Integer brokerId) {
        this.brokerId = brokerId;
    }

    public PartitionBackupInfo brokerVersion(String brokerVersion) {
        this.brokerVersion = brokerVersion;
        return this;
    }

    @Schema(name="brokerVersion", accessMode=Schema.AccessMode.READ_ONLY, example="8.1.2", description="The version of the broker from which the backup was taken for this partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokerVersion")
    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(String brokerVersion) {
        this.brokerVersion = brokerVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionBackupInfo partitionBackupInfo = (PartitionBackupInfo)o;
        return Objects.equals(this.partitionId, partitionBackupInfo.partitionId) && Objects.equals((Object)this.state, (Object)partitionBackupInfo.state) && Objects.equals(this.failureReason, partitionBackupInfo.failureReason) && Objects.equals(this.createdAt, partitionBackupInfo.createdAt) && Objects.equals(this.lastUpdatedAt, partitionBackupInfo.lastUpdatedAt) && Objects.equals(this.snapshotId, partitionBackupInfo.snapshotId) && Objects.equals(this.checkpointPosition, partitionBackupInfo.checkpointPosition) && Objects.equals(this.brokerId, partitionBackupInfo.brokerId) && Objects.equals(this.brokerVersion, partitionBackupInfo.brokerVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionId, this.state, this.failureReason, this.createdAt, this.lastUpdatedAt, this.snapshotId, this.checkpointPosition, this.brokerId, this.brokerVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartitionBackupInfo {\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("    snapshotId: ").append(this.toIndentedString(this.snapshotId)).append("\n");
        sb.append("    checkpointPosition: ").append(this.toIndentedString(this.checkpointPosition)).append("\n");
        sb.append("    brokerId: ").append(this.toIndentedString(this.brokerId)).append("\n");
        sb.append("    brokerVersion: ").append(this.toIndentedString(this.brokerVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

