/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import java.util.List;

public class IntermediateCatchEventProcessor
implements BpmnElementProcessor<ExecutableCatchEventElement> {
    private final List<IntermediateCatchEventBehavior> catchEventBehaviors = List.of(new DefaultIntermediateCatchEventBehavior(), new LinkIntermediateCatchEventBehavior());
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;

    public IntermediateCatchEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableCatchEventElement> getType() {
        return ExecutableCatchEventElement.class;
    }

    @Override
    public void onActivate(ExecutableCatchEventElement element, BpmnElementContext activating) {
        this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public void onComplete(ExecutableCatchEventElement element, BpmnElementContext completing) {
        this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(completing);
            return this.stateTransitionBehavior.transitionToCompleted(element, completing);
        }).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, completing));
    }

    @Override
    public void onTerminate(ExecutableCatchEventElement element, BpmnElementContext terminating) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(terminating);
        this.incidentBehavior.resolveIncidents(terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private IntermediateCatchEventBehavior eventBehaviorOf(ExecutableCatchEventElement element) {
        return this.catchEventBehaviors.stream().filter(behavior -> behavior.isSuitableForEvent(element)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This kind of intermediate catch event is not supported."));
    }

    private final class DefaultIntermediateCatchEventBehavior
    implements IntermediateCatchEventBehavior {
        private DefaultIntermediateCatchEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableCatchEventElement element) {
            return !element.isLink();
        }

        @Override
        public void onActivate(ExecutableCatchEventElement element, BpmnElementContext activating) {
            IntermediateCatchEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> IntermediateCatchEventProcessor.this.eventSubscriptionBehavior.subscribeToEvents(element, activating)).ifRightOrLeft(ok -> IntermediateCatchEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating), failure -> IntermediateCatchEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }
    }

    private final class LinkIntermediateCatchEventBehavior
    implements IntermediateCatchEventBehavior {
        private LinkIntermediateCatchEventBehavior() {
        }

        @Override
        public boolean isSuitableForEvent(ExecutableCatchEventElement element) {
            return element.isLink();
        }

        @Override
        public void onActivate(ExecutableCatchEventElement element, BpmnElementContext activating) {
            BpmnElementContext activated = IntermediateCatchEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            IntermediateCatchEventProcessor.this.stateTransitionBehavior.completeElement(activated);
        }
    }

    private static interface IntermediateCatchEventBehavior {
        public boolean isSuitableForEvent(ExecutableCatchEventElement var1);

        public void onActivate(ExecutableCatchEventElement var1, BpmnElementContext var2);
    }
}

