/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import org.agrona.DirectBuffer;

public class SignalBroadcastProcessor
implements DistributedTypedRecordProcessor<SignalRecord> {
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final EventHandle eventHandle;
    private final TypedResponseWriter responseWriter;
    private final SignalSubscriptionState signalSubscriptionState;
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;

    public SignalBroadcastProcessor(Writers writers, KeyGenerator keyGenerator, ProcessingState processingState, BpmnStateBehavior stateBehavior, EventTriggerBehavior eventTriggerBehavior, CommandDistributionBehavior commandDistributionBehavior) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.processState = processingState.getProcessState();
        this.signalSubscriptionState = processingState.getSignalSubscriptionState();
        this.keyGenerator = keyGenerator;
        this.commandDistributionBehavior = commandDistributionBehavior;
        this.elementInstanceState = processingState.getElementInstanceState();
        this.eventHandle = new EventHandle(keyGenerator, processingState.getEventScopeInstanceState(), writers, this.processState, eventTriggerBehavior, stateBehavior);
    }

    @Override
    public void processNewCommand(TypedRecord<SignalRecord> command) {
        long eventKey = this.keyGenerator.nextKey();
        SignalRecord signalRecord = (SignalRecord)command.getValue();
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)SignalIntent.BROADCASTED, (RecordValue)signalRecord);
        if (command.hasRequestMetadata()) {
            this.responseWriter.writeEventOnCommand(eventKey, (Intent)SignalIntent.BROADCASTED, (UnpackedObject)signalRecord, command);
        }
        this.signalSubscriptionState.visitBySignalName(signalRecord.getSignalNameBuffer(), subscription -> {
            SignalSubscriptionRecord subscriptionRecord = subscription.getRecord();
            if (subscriptionRecord.getCatchEventInstanceKey() == -1L) {
                this.eventHandle.activateProcessInstanceForStartEvent(subscriptionRecord.getProcessDefinitionKey(), this.keyGenerator.nextKey(), subscriptionRecord.getCatchEventIdBuffer(), signalRecord.getVariablesBuffer(), signalRecord.getTenantId());
            } else {
                this.activateElement(subscriptionRecord, signalRecord.getVariablesBuffer());
            }
        });
        this.commandDistributionBehavior.distributeCommand(eventKey, command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<SignalRecord> command) {
        SignalRecord value = (SignalRecord)command.getValue();
        this.signalSubscriptionState.visitBySignalName(value.getSignalNameBuffer(), subscription -> this.activateElement(subscription.getRecord(), value.getVariablesBuffer()));
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)SignalIntent.BROADCASTED, (RecordValue)command.getValue());
        this.commandDistributionBehavior.acknowledgeCommand(command.getKey(), command);
    }

    private void activateElement(SignalSubscriptionRecord subscription, DirectBuffer variables) {
        long processDefinitionKey = subscription.getProcessDefinitionKey();
        long catchEventInstanceKey = subscription.getCatchEventInstanceKey();
        DirectBuffer catchEventId = subscription.getCatchEventIdBuffer();
        ExecutableCatchEvent catchEvent = this.processState.getFlowElement(processDefinitionKey, subscription.getTenantId(), catchEventId, ExecutableCatchEvent.class);
        ElementInstance elementInstance = this.elementInstanceState.getInstance(catchEventInstanceKey);
        boolean canTriggerElement = this.eventHandle.canTriggerElement(elementInstance, catchEventId);
        if (canTriggerElement) {
            this.eventHandle.activateElement(catchEvent, catchEventInstanceKey, elementInstance.getValue(), variables);
        }
    }
}

