/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class DbJobState
implements JobState,
MutableJobState {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private final JobRecordValue jobRecordToWrite = new JobRecordValue();
    private final DbLong jobKey;
    private final DbForeignKey<DbLong> fkJob;
    private final ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbString tenantIdKey;
    private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>> tenantAwareTypeJobKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>, DbNil> activatableColumnFamily;
    private final DbLong deadlineKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlinesColumnFamily;
    private final DbLong backoffKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;
    private long nextBackOffDueDate;

    public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.statesJobColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_STATES, transactionContext, this.fkJob, (DbValue)this.jobState);
        this.jobTypeKey = new DbString();
        this.tenantIdKey = new DbString();
        this.typeJobKey = new DbCompositeKey((DbKey)this.jobTypeKey, this.fkJob);
        this.tenantAwareTypeJobKey = new DbTenantAwareKey(this.tenantIdKey, this.typeJobKey, DbTenantAwareKey.PlacementType.SUFFIX);
        this.activatableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.tenantAwareTypeJobKey, (DbValue)DbNil.INSTANCE);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey((DbKey)this.deadlineKey, this.fkJob);
        this.deadlinesColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_DEADLINES, transactionContext, this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey((DbKey)this.backoffKey, this.fkJob);
        this.backoffColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_BACKOFF, transactionContext, this.backoffJobKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    @Override
    public void activate(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        String tenantId = record.getTenantId();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan((String)"deadline", (long)deadline, (long)0L);
        this.updateJobRecord(key, record);
        this.updateJobState(JobState.State.ACTIVATED);
        this.makeJobNotActivatable(type, tenantId);
        this.addJobDeadline(key, deadline);
    }

    @Override
    public void recurAfterBackoff(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void timeout(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan((String)"deadline", (long)deadline, (long)0L);
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
    }

    @Override
    public void complete(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void cancel(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void disable(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.FAILED);
        this.makeJobNotActivatable(record.getTypeBuffer(), record.getTenantId());
    }

    @Override
    public void throwError(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ERROR_THROWN);
        this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
    }

    @Override
    public void delete(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        String tenantId = record.getTenantId();
        this.jobKey.wrapLong(key);
        this.jobsColumnFamily.deleteExisting((DbKey)this.jobKey);
        this.statesJobColumnFamily.deleteExisting(this.fkJob);
        this.makeJobNotActivatable(type, tenantId);
        this.removeJobDeadline(key, record.getDeadline());
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void fail(long key, JobRecord updatedValue) {
        if (updatedValue.getRetries() > 0) {
            if (updatedValue.getRetryBackoff() > 0L) {
                this.addJobBackoff(key, updatedValue.getRecurringTime());
                this.updateJob(key, updatedValue, JobState.State.FAILED);
                this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
            } else {
                this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
            }
        } else {
            this.updateJob(key, updatedValue, JobState.State.FAILED);
            this.makeJobNotActivatable(updatedValue.getTypeBuffer(), updatedValue.getTenantId());
        }
    }

    @Override
    public void yield(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public void resolve(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public JobRecord updateJobRetries(long jobKey, int retries) {
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            job.setRetries(retries);
            this.updateJobRecord(jobKey, job);
        }
        return job;
    }

    @Override
    public void cleanupTimeoutsWithoutJobs() {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long deadline = ((DbLong)key.first()).getValue();
            JobRecordValue job = (JobRecordValue)this.jobsColumnFamily.get((DbKey)jobKey);
            if (job == null || job.getRecord().getDeadline() != deadline) {
                this.deadlinesColumnFamily.deleteExisting(key);
            }
            return true;
        });
    }

    @Override
    public void cleanupBackoffsWithoutJobs() {
        this.backoffColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long backoff = ((DbLong)key.first()).getValue();
            JobRecordValue job = (JobRecordValue)this.jobsColumnFamily.get((DbKey)jobKey);
            if (job == null || job.getRecord().getRecurringTime() != backoff) {
                LOG.debug("Deleting orphaned job with key {}", (Object)key);
                this.backoffColumnFamily.deleteExisting(key);
            }
            return true;
        });
    }

    @Override
    public void restoreBackoff() {
        Set<Long> failedKeys = this.getFailedJobKeys();
        failedKeys.removeAll(this.getBackoffJobKeys());
        failedKeys.forEach(key -> {
            this.jobKey.wrapLong(key.longValue());
            JobRecordValue jobRecord = (JobRecordValue)this.jobsColumnFamily.get((DbKey)this.jobKey);
            if (this.isValidForRestore(jobRecord)) {
                this.addJobBackoff((long)key, jobRecord.getRecord().getRecurringTime());
            }
        });
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.createJobRecord(key, record);
        this.initializeJobState();
        this.makeJobActivatable(type, key, record.getTenantId());
    }

    private void updateJob(long key, JobRecord updatedValue, JobState.State newState) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        this.validateParameters(type);
        this.updateJobRecord(key, updatedValue);
        this.updateJobState(newState);
        if (newState == JobState.State.ACTIVATABLE) {
            this.makeJobActivatable(type, key, updatedValue.getTenantId());
        }
        if (newState != JobState.State.ACTIVATED) {
            this.removeJobDeadline(key, updatedValue.getDeadline());
        }
    }

    private void validateParameters(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
    }

    @Override
    public void forEachTimedOutEntry(long upperBound, BiPredicate<Long, JobRecord> callback) {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            boolean isDue;
            long deadline = ((DbLong)key.first()).getValue();
            boolean bl = isDue = deadline < upperBound;
            if (isDue) {
                long jobKey1 = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                return this.visitJob(jobKey1, callback);
            }
            return false;
        });
    }

    @Override
    public boolean exists(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        return this.jobsColumnFamily.exists((DbKey)this.jobKey);
    }

    @Override
    public JobState.State getState(long key) {
        this.jobKey.wrapLong(key);
        JobStateValue storedState = (JobStateValue)this.statesJobColumnFamily.get(this.fkJob);
        if (storedState == null) {
            return JobState.State.NOT_FOUND;
        }
        return storedState.getState();
    }

    @Override
    public boolean isInState(long key, JobState.State state) {
        return this.getState(key) == state;
    }

    @Override
    public void forEachActivatableJobs(DirectBuffer type, List<String> tenantIds, BiFunction<Long, JobRecord, Boolean> callback) {
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.whileEqualPrefix((DbKey)this.jobTypeKey, (tenantAwareCompositeKey, zbNil) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)((DbCompositeKey)tenantAwareCompositeKey.wrappedKey()).second()).inner();
            String tenantId = tenantAwareCompositeKey.tenantKey().toString();
            if (tenantIds.contains(tenantId)) {
                return this.visitJob(jobKey.getValue(), callback::apply);
            }
            return true;
        });
    }

    @Override
    public JobRecord getJob(long key) {
        this.jobKey.wrapLong(key);
        JobRecordValue jobState = (JobRecordValue)this.jobsColumnFamily.get((DbKey)this.jobKey);
        return jobState == null ? null : jobState.getRecord();
    }

    @Override
    public JobRecord getJob(long key, Map<String, Object> authorizations) {
        JobRecord jobRecord = this.getJob(key);
        if (jobRecord != null && this.getAuthorizedTenantIds(authorizations).contains(jobRecord.getTenantId())) {
            return jobRecord;
        }
        return null;
    }

    @Override
    public long findBackedOffJobs(long timestamp, BiPredicate<Long, JobRecord> callback) {
        this.nextBackOffDueDate = -1L;
        this.backoffColumnFamily.whileTrue((key, value) -> {
            long deadline = ((DbLong)key.first()).getValue();
            boolean consumed = false;
            if (deadline <= timestamp) {
                long jobKey = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                consumed = this.visitJob(jobKey, callback);
            }
            if (!consumed) {
                this.nextBackOffDueDate = deadline;
            }
            return consumed;
        });
        return this.nextBackOffDueDate;
    }

    boolean visitJob(long jobKey, BiPredicate<Long, JobRecord> callback) {
        JobRecord job = this.getJob(jobKey);
        if (job == null) {
            LOG.error("Expected to find job with key {}, but no job found", (Object)jobKey);
            return true;
        }
        return callback.test(jobKey, job);
    }

    private void createJobRecord(long key, JobRecord record) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(record);
        this.jobsColumnFamily.insert((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void updateJobRecord(long key, JobRecord updatedValue) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(updatedValue);
        this.jobsColumnFamily.update((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void initializeJobState() {
        this.jobState.setState(JobState.State.ACTIVATABLE);
        this.statesJobColumnFamily.insert(this.fkJob, (DbValue)this.jobState);
    }

    private void updateJobState(JobState.State newState) {
        this.jobState.setState(newState);
        this.statesJobColumnFamily.update(this.fkJob, (DbValue)this.jobState);
    }

    private void makeJobActivatable(DirectBuffer type, long key, String tenantId) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        EnsureUtil.ensureNotNullOrEmpty((String)"tenantId", (String)tenantId);
        this.jobTypeKey.wrapBuffer(type);
        this.jobKey.wrapLong(key);
        this.tenantIdKey.wrapString(tenantId);
        this.activatableColumnFamily.upsert(this.tenantAwareTypeJobKey, (DbValue)DbNil.INSTANCE);
    }

    private void makeJobNotActivatable(DirectBuffer type, String tenantId) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        EnsureUtil.ensureNotNullOrEmpty((String)"tenantid", (String)tenantId);
        this.jobTypeKey.wrapBuffer(type);
        this.tenantIdKey.wrapString(tenantId);
        this.activatableColumnFamily.deleteIfExists(this.tenantAwareTypeJobKey);
    }

    private void addJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.insert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        }
    }

    private void removeJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.deleteIfExists(this.deadlineJobKey);
        }
    }

    private void addJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.insert(this.backoffJobKey, (DbValue)DbNil.INSTANCE);
        }
    }

    private void removeJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.deleteIfExists(this.backoffJobKey);
        }
    }

    private List<String> getAuthorizedTenantIds(Map<String, Object> authorizations) {
        return (List)authorizations.get("authorized_tenants");
    }

    private Set<Long> getFailedJobKeys() {
        HashSet<Long> failedJobKeys = new HashSet<Long>();
        this.statesJobColumnFamily.forEach((key, value) -> {
            if (JobState.State.FAILED.equals((Object)value.getState())) {
                failedJobKeys.add(((DbLong)key.inner()).getValue());
            }
        });
        return failedJobKeys;
    }

    private Set<Long> getBackoffJobKeys() {
        HashSet<Long> backoffJobKeys = new HashSet<Long>();
        this.backoffColumnFamily.forEach((key, value) -> backoffJobKeys.add(((DbLong)((DbForeignKey)key.second()).inner()).getValue()));
        return backoffJobKeys;
    }

    private boolean isValidForRestore(JobRecordValue jobRecord) {
        if (jobRecord == null) {
            return false;
        }
        JobRecord job = jobRecord.getRecord();
        return job.getRecurringTime() > -1L && job.getRetries() > 0;
    }
}

