/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.cluster.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftError;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.RaftClusterContext;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class DefaultRaftMember
implements RaftMember,
AutoCloseable {
    private final MemberId id;
    private final int hash;
    private final transient Set<Consumer<RaftMember.Type>> typeChangeListeners = new CopyOnWriteArraySet<Consumer<RaftMember.Type>>();
    private RaftMember.Type type;
    private Instant updated;
    private transient Scheduled configureTimeout;
    private transient RaftClusterContext cluster;

    public DefaultRaftMember(MemberId id, RaftMember.Type type, Instant updated) {
        this.id = (MemberId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.hash = Hashing.murmur3_32_fixed().hashUnencodedChars((CharSequence)((Object)id.id())).asInt();
        this.setType((RaftMember.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null")));
        this.updated = (Instant)Preconditions.checkNotNull((Object)updated, (Object)"updated cannot be null");
    }

    @Override
    public MemberId memberId() {
        return this.id;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public void addTypeChangeListener(Consumer<RaftMember.Type> listener) {
        this.typeChangeListeners.add(listener);
    }

    @Override
    public CompletableFuture<Void> promote() {
        if (RaftMember.Type.values().length > this.type.ordinal() + 1) {
            return this.configure(RaftMember.Type.values()[this.type.ordinal() + 1]);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> promote(RaftMember.Type type) {
        return this.configure(type);
    }

    @Override
    public CompletableFuture<Void> demote() {
        if (this.type.ordinal() > 0) {
            return this.configure(RaftMember.Type.values()[this.type.ordinal() - 1]);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> demote(RaftMember.Type type) {
        return this.configure(type);
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.configure(RaftMember.Type.INACTIVE);
    }

    @Override
    public Instant getLastUpdated() {
        return this.updated;
    }

    @Override
    public RaftMember.Type getType() {
        return this.type;
    }

    void setType(RaftMember.Type type) {
        this.type = type;
    }

    public DefaultRaftMember update(RaftMember.Type type, Instant time) {
        if (this.type != type) {
            this.setType((RaftMember.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null")));
            if (time.isAfter(this.updated)) {
                this.updated = (Instant)Preconditions.checkNotNull((Object)time, (Object)"time cannot be null");
            }
            this.typeChangeListeners.forEach(l -> l.accept(type));
        }
        return this;
    }

    private CompletableFuture<Void> configure(RaftMember.Type type) {
        if (type == this.type) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.cluster.getContext().getThreadContext().execute(() -> this.configure(type, future));
        return future;
    }

    private void configure(RaftMember.Type type, CompletableFuture<Void> future) {
        this.configureTimeout = this.cluster.getContext().getThreadContext().schedule(this.cluster.getContext().getElectionTimeout(), () -> this.configure(type, future));
        Configuration currentConfiguration = this.cluster.getConfiguration();
        this.cluster.getContext().getRaftRole().onReconfigure(ReconfigureRequest.builder().withIndex(currentConfiguration.index()).withTerm(currentConfiguration.term()).withMembers(currentConfiguration.newMembers()).withMember(new DefaultRaftMember(this.id, type, this.updated)).build()).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    this.cancelConfigureTimer();
                    this.cluster.configure(new Configuration(response.index(), response.term(), response.timestamp(), response.members()));
                    future.complete(null);
                } else if (response.error() == null || response.error().type() == RaftError.Type.UNAVAILABLE || response.error().type() == RaftError.Type.PROTOCOL_ERROR || response.error().type() == RaftError.Type.NO_LEADER) {
                    this.cancelConfigureTimer();
                    this.configureTimeout = this.cluster.getContext().getThreadContext().schedule(this.cluster.getContext().getElectionTimeout().multipliedBy(2L), () -> this.configure(type, future));
                } else {
                    this.cancelConfigureTimer();
                    future.completeExceptionally((Throwable)((Object)response.error().createException()));
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
    }

    @Override
    public void close() {
        this.cancelConfigureTimer();
    }

    private void cancelConfigureTimer() {
        if (this.configureTimeout != null) {
            this.configureTimeout.cancel();
            this.configureTimeout = null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.id);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultRaftMember && ((DefaultRaftMember)object).id.equals(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("updated", (Object)this.updated).toString();
    }

    DefaultRaftMember setCluster(RaftClusterContext cluster) {
        this.cluster = cluster;
        return this;
    }
}

