/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.cluster.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftCluster;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftMemberContext;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.utils.JointConsensusVoteQuorum;
import io.atomix.raft.utils.SimpleVoteQuorum;
import io.atomix.raft.utils.VoteQuorum;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class RaftClusterContext
implements RaftCluster,
AutoCloseable {
    private final RaftContext raft;
    private final DefaultRaftMember localMember;
    private final Map<MemberId, RaftMemberContext> remoteMemberContexts = new HashMap<MemberId, RaftMemberContext>();
    private final Set<RaftMemberContext> replicationTargets = new HashSet<RaftMemberContext>();
    private final Set<RaftMemberContext> remoteActiveMembers = new HashSet<RaftMemberContext>();
    private boolean hasRemoteActiveMembers = false;
    private Configuration configuration;

    public RaftClusterContext(MemberId localMemberId, RaftContext raft) {
        Instant time = Instant.now();
        this.localMember = new DefaultRaftMember(localMemberId, RaftMember.Type.PASSIVE, time).setCluster(this);
        this.raft = (RaftContext)Preconditions.checkNotNull((Object)raft, (Object)"context cannot be null");
        Configuration storedConfiguration = raft.getMetaStore().loadConfiguration();
        if (storedConfiguration != null) {
            this.updateConfiguration(storedConfiguration);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.raft.getName()).toString();
    }

    @Override
    public CompletableFuture<Void> bootstrap(Collection<MemberId> cluster) {
        CompletableFuture<Void> bootstrapFuture = new CompletableFuture<Void>();
        this.raft.getThreadContext().execute(() -> {
            if (this.configuration == null) {
                this.createInitialConfig(cluster);
            }
            this.raft.transition(this.localMember.getType());
            bootstrapFuture.complete(null);
        });
        return bootstrapFuture;
    }

    @Override
    public CompletableFuture<Void> join(Collection<MemberId> cluster) {
        return this.raft.join(cluster);
    }

    @Override
    public DefaultRaftMember getMember(MemberId id) {
        if (this.localMember.memberId().equals(id)) {
            return this.localMember;
        }
        RaftMemberContext context = this.remoteMemberContexts.get(id);
        return context != null ? context.getMember() : null;
    }

    @Override
    public RaftMember getLocalMember() {
        return this.localMember;
    }

    @Override
    public Collection<RaftMember> getMembers() {
        return this.configuration.allMembers();
    }

    private void createInitialConfig(Collection<MemberId> cluster) {
        this.localMember.setType(RaftMember.Type.ACTIVE);
        Set<RaftMember> activeMembers = cluster.stream().filter(m -> !m.equals(this.localMember.memberId())).map(m -> new DefaultRaftMember((MemberId)m, RaftMember.Type.ACTIVE, this.localMember.getLastUpdated())).collect(Collectors.toSet());
        activeMembers.add(this.localMember);
        Configuration initialConfiguration = new Configuration(0L, 0L, this.localMember.getLastUpdated().toEpochMilli(), activeMembers);
        this.configure(initialConfiguration);
        this.commitCurrentConfiguration();
    }

    public RaftMemberContext getMemberContext(MemberId id) {
        return this.remoteMemberContexts.get(id);
    }

    public <T extends Comparable<T>> Optional<T> getQuorumFor(Function<RaftMemberContext, T> calculateMemberValue) {
        ArrayList<RaftMemberContext> contexts = new ArrayList<RaftMemberContext>(this.remoteActiveMembers);
        if (this.configuration.requiresJointConsensus()) {
            Collection<RaftMember> oldMembers = this.configuration.oldMembers();
            Collection<RaftMember> newMembers = this.configuration.newMembers();
            ArrayList oldContexts = contexts.stream().filter(context -> oldMembers.contains(context.getMember())).collect(Collectors.toCollection(ArrayList::new));
            ArrayList newContexts = contexts.stream().filter(context -> newMembers.contains(context.getMember())).collect(Collectors.toCollection(ArrayList::new));
            Optional<T> oldQuorum = this.getQuorumFor(oldContexts, calculateMemberValue);
            Optional<T> newQuorum = this.getQuorumFor(newContexts, calculateMemberValue);
            if (oldQuorum.isPresent() && newQuorum.isPresent()) {
                return Optional.of(Comparators.min((Comparable)((Comparable)oldQuorum.get()), (Comparable)((Comparable)newQuorum.get())));
            }
            if (oldQuorum.isPresent()) {
                return oldQuorum;
            }
            return newQuorum;
        }
        return this.getQuorumFor(contexts, calculateMemberValue);
    }

    private <T extends Comparable<T>> Optional<T> getQuorumFor(List<RaftMemberContext> contexts, Function<RaftMemberContext, T> calculateMemberValue) {
        if (contexts.isEmpty()) {
            return Optional.empty();
        }
        contexts.sort(Comparator.comparing(calculateMemberValue).reversed());
        int remoteActiveMembers = contexts.size();
        int totalActiveMembers = remoteActiveMembers + 1;
        int quorum = totalActiveMembers / 2 + 1;
        int remoteQuorumIndex = quorum - 1 - 1;
        RaftMemberContext context = contexts.get(remoteQuorumIndex);
        return Optional.of((Comparable)calculateMemberValue.apply(context));
    }

    public boolean isSingleMemberCluster() {
        return !this.hasRemoteActiveMembers;
    }

    public Set<RaftMember> getVotingMembers() {
        return this.remoteActiveMembers.stream().map(RaftMemberContext::getMember).collect(Collectors.toSet());
    }

    public Set<RaftMemberContext> getReplicationTargets() {
        return this.replicationTargets;
    }

    public boolean isMember(MemberId memberId) {
        return this.localMember.memberId().equals(memberId) || this.remoteMemberContexts.containsKey(memberId);
    }

    public boolean inJointConsensus() {
        return this.configuration.requiresJointConsensus();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public RaftContext getContext() {
        return this.raft;
    }

    public VoteQuorum getVoteQuorum(Consumer<Boolean> callback) {
        VoteQuorum quorum = this.configuration.requiresJointConsensus() ? new JointConsensusVoteQuorum(callback, this.configuration.oldMembers().stream().map(RaftMember::memberId).collect(Collectors.toSet()), this.configuration.newMembers().stream().map(RaftMember::memberId).collect(Collectors.toSet())) : new SimpleVoteQuorum(callback, this.configuration.newMembers().stream().map(RaftMember::memberId).collect(Collectors.toSet()));
        quorum.succeed(this.localMember.memberId());
        return quorum;
    }

    public RaftClusterContext reset() {
        Configuration storedConfiguration = this.raft.getMetaStore().loadConfiguration();
        if (storedConfiguration != null) {
            this.configure(storedConfiguration);
        }
        return this;
    }

    public void configure(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration cannot be null");
        Configuration currentConfig = this.configuration;
        if (currentConfig != null && configuration.index() <= currentConfig.index()) {
            return;
        }
        this.updateConfiguration(configuration);
        if (this.wasPromoted(currentConfig, configuration, this.localMember)) {
            this.raft.transition(this.localMember.getType());
        }
        if (this.raft.getCommitIndex() >= configuration.index()) {
            this.commitCurrentConfiguration();
        }
    }

    private boolean wasPromoted(Configuration previousConfig, Configuration updatedConfig, RaftMember member) {
        if (previousConfig == null) {
            return true;
        }
        Collection<RaftMember> previousMembers = previousConfig.newMembers();
        Collection<RaftMember> updatedMembers = updatedConfig.newMembers();
        Optional<RaftMember> previousMember = previousMembers.stream().filter(m -> m.equals(member)).findFirst();
        Optional<RaftMember> updatedMember = updatedMembers.stream().filter(m -> m.equals(member)).findFirst();
        return previousMember.isPresent() && updatedMember.isPresent() && previousMember.get().getType().ordinal() < updatedMember.get().getType().ordinal();
    }

    private void updateConfiguration(Configuration configuration) {
        Instant time = Instant.ofEpochMilli(configuration.time());
        Set<RaftMember> membersInNewConfiguration = configuration.allMembers();
        if (!membersInNewConfiguration.contains(this.localMember)) {
            this.localMember.update(RaftMember.Type.INACTIVE, time);
        }
        List<DefaultRaftMember> membersToRemove = this.remoteMemberContexts.values().stream().map(RaftMemberContext::getMember).filter(Predicate.not(membersInNewConfiguration::contains)).toList();
        for (DefaultRaftMember defaultRaftMember : membersToRemove) {
            this.removeMemberContext(defaultRaftMember);
        }
        for (RaftMember raftMember : membersInNewConfiguration) {
            this.updateMemberContext(raftMember, time);
        }
        this.configuration = configuration;
    }

    private void removeMemberContext(RaftMember member) {
        MemberId memberId = member.memberId();
        RaftMemberContext context = this.remoteMemberContexts.get(memberId);
        if (context != null) {
            context.close();
            this.remoteMemberContexts.remove(memberId);
            this.remoteActiveMembers.remove(context);
            this.replicationTargets.remove(context);
            this.hasRemoteActiveMembers = !this.remoteActiveMembers.isEmpty();
        }
    }

    private void updateMemberContext(RaftMember member, Instant time) {
        if (member.equals(this.localMember)) {
            this.localMember.update(member.getType(), time);
            return;
        }
        RaftMemberContext context = this.remoteMemberContexts.computeIfAbsent(member.memberId(), memberId -> new RaftMemberContext(new DefaultRaftMember((MemberId)memberId, member.getType(), time), this, this.raft.getMaxAppendsPerFollower()));
        if (context.getMember().getType() != member.getType()) {
            context.getMember().update(member.getType(), time);
            context.resetState(this.raft.getLog());
        }
        if (member.getType() == RaftMember.Type.ACTIVE) {
            this.remoteActiveMembers.add(context);
            this.hasRemoteActiveMembers = true;
        } else if (this.remoteActiveMembers.remove(context)) {
            boolean bl = this.hasRemoteActiveMembers = !this.remoteActiveMembers.isEmpty();
        }
        if (member.getType() != RaftMember.Type.INACTIVE) {
            this.replicationTargets.add(context);
        }
    }

    public void commitCurrentConfiguration() {
        Configuration storedConfiguration = this.raft.getMetaStore().loadConfiguration();
        if (storedConfiguration == null || storedConfiguration.index() < this.configuration.index()) {
            this.raft.getMetaStore().storeConfiguration(this.configuration);
        }
        this.raft.transition(this.localMember.getType());
    }

    @Override
    public void close() {
        this.remoteMemberContexts.values().forEach(RaftMemberContext::close);
        this.localMember.close();
    }
}

