/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Gauge;

public class RaftStartupMetrics
extends RaftMetrics {
    private static final Gauge BOOTSTRAP_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken to bootstrap the partition server (in ms)")).name("partition_server_bootstrap_time")).register();
    private static final Gauge JOIN_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken for the partition server to join (in ms)")).name("partition_server_join_time")).register();
    private final Gauge.Child bootstrapDuration;
    private final Gauge.Child joinDuration;

    public RaftStartupMetrics(String partitionName) {
        super(partitionName);
        this.bootstrapDuration = (Gauge.Child)BOOTSTRAP_DURATION.labels(new String[]{this.partitionGroupName, this.partition});
        this.joinDuration = (Gauge.Child)JOIN_DURATION.labels(new String[]{this.partitionGroupName, this.partition});
    }

    public void observeBootstrapDuration(long durationMillis) {
        this.bootstrapDuration.set((double)durationMillis);
    }

    public void observeJoinDuration(long durationMillis) {
        this.joinDuration.set((double)durationMillis);
    }
}

