/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.raft.ElectionTimer;
import io.atomix.raft.ElectionTimerFactory;
import io.atomix.raft.RaftServer;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.InternalAppendRequest;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.ActiveRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.utils.VoteQuorum;
import io.atomix.utils.AbstractIdentifier;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FollowerRole
extends ActiveRole {
    private final ElectionTimer electionTimer;
    private final ClusterMembershipEventListener clusterListener = this::handleClusterEvent;

    public FollowerRole(RaftContext context, ElectionTimerFactory electionTimerFactory) {
        super(context);
        this.electionTimer = electionTimerFactory.create(this::schedulePollRequests, this.log);
    }

    @Override
    public synchronized CompletableFuture<RaftRole> start() {
        this.raft.getMembershipService().addListener(this.clusterListener);
        if (this.raft.getCluster().isSingleMemberCluster()) {
            this.log.info("Single member cluster. Transitioning directly to candidate.");
            this.raft.transition(RaftServer.Role.CANDIDATE);
            return CompletableFuture.completedFuture(this);
        }
        return ((CompletableFuture)super.start().thenRun(this.electionTimer::reset)).thenApply(v -> this);
    }

    @Override
    public synchronized CompletableFuture<Void> stop() {
        this.raft.getMembershipService().removeListener(this.clusterListener);
        this.electionTimer.cancel();
        return super.stop();
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.FOLLOWER;
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        CompletableFuture<InstallResponse> future = super.onInstall(request);
        if (this.isRequestFromCurrentLeader(request.currentTerm(), request.leader())) {
            this.onHeartbeatFromLeader();
        }
        return future;
    }

    private void handleClusterEvent(ClusterMembershipEvent event) {
        this.raft.getThreadContext().execute(() -> {
            DefaultRaftMember leader = this.raft.getLeader();
            if (leader != null && event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED && ((Member)event.subject()).id().equals(leader.memberId())) {
                this.log.info("Known leader {} was removed from cluster, sending poll requests", (Object)leader.memberId());
                this.raft.setLeader(null);
                this.sendPollRequests();
            }
        });
    }

    private void sendPollRequests() {
        AtomicBoolean complete = new AtomicBoolean();
        Set<RaftMember> votingMembers = this.raft.getCluster().getVotingMembers();
        if (votingMembers.isEmpty()) {
            this.log.info("Transitioning to candidate as there are no known other active members");
            this.raft.transition(RaftServer.Role.CANDIDATE);
            return;
        }
        this.log.info("Sending poll requests to all active members: {}", votingMembers);
        VoteQuorum quorum = this.raft.getCluster().getVoteQuorum(elected -> {
            complete.set(true);
            if (this.raft.getLeader() == null && elected.booleanValue()) {
                this.raft.transition(RaftServer.Role.CANDIDATE);
            } else {
                this.electionTimer.reset();
            }
        });
        IndexedRaftLogEntry lastEntry = this.raft.getLog().getLastEntry();
        long lastTerm = lastEntry != null ? lastEntry.term() : 0L;
        for (RaftMember member : votingMembers) {
            this.log.debug("Polling {} for next term {}", (Object)member, (Object)(this.raft.getTerm() + 1L));
            PollRequest request = PollRequest.builder().withTerm(this.raft.getTerm()).withCandidate(this.raft.getCluster().getLocalMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.raft.getProtocol().poll(member.memberId(), request).whenCompleteAsync((response, error) -> this.handlePollResponse(complete, quorum, member, (PollResponse)response, (Throwable)error), (Executor)this.raft.getThreadContext());
        }
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        CompletableFuture<ConfigureResponse> future = super.onConfigure(request);
        if (this.isRequestFromCurrentLeader(request.term(), request.leader())) {
            this.onHeartbeatFromLeader();
        }
        return future;
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(InternalAppendRequest request) {
        CompletableFuture<AppendResponse> future = super.onAppend(request);
        if (this.isRequestFromCurrentLeader(request.term(), request.leader())) {
            this.onHeartbeatFromLeader();
        }
        return future;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.onHeartbeatFromLeader();
        }
        return response;
    }

    private boolean isRequestFromCurrentLeader(long term, MemberId leader) {
        long currentTerm = this.raft.getTerm();
        DefaultRaftMember currentLeader = this.raft.getLeader();
        if (term < currentTerm || term == currentTerm && (currentLeader == null || !leader.equals(currentLeader.memberId()))) {
            this.log.debug("Expected heartbeat from {} in term {}, but received one from {} in term {}, ignoring it", new Object[]{currentLeader, currentTerm, leader, leader});
            return false;
        }
        return true;
    }

    private void onHeartbeatFromLeader() {
        this.raft.checkThread();
        if (!this.isRunning()) {
            return;
        }
        this.updateHeartbeat(System.currentTimeMillis());
        this.electionTimer.reset();
    }

    private void updateHeartbeat(long currentTimestamp) {
        if (this.raft.getLastHeartbeat() > 0L) {
            this.raft.getRaftRoleMetrics().observeHeartbeatInterval(currentTimestamp - this.raft.getLastHeartbeat());
        }
        this.raft.setLastHeartbeat(currentTimestamp);
    }

    private void schedulePollRequests() {
        this.raft.checkThread();
        if (!this.isRunning()) {
            return;
        }
        if (this.raft.getFirstCommitIndex() == 0L || this.raft.getState() == RaftContext.State.READY) {
            long timeSinceLastHeartbeatMs = System.currentTimeMillis() - this.raft.getLastHeartbeat();
            String leader = Optional.ofNullable(this.raft.getLeader()).map(DefaultRaftMember::memberId).map(AbstractIdentifier::id).orElse("a known leader");
            this.log.info("No heartbeat from {} since {}ms", (Object)leader, (Object)timeSinceLastHeartbeatMs);
            this.raft.getRaftRoleMetrics().countHeartbeatMiss();
            this.raft.setLeader(null);
            this.sendPollRequests();
        }
    }

    private void handlePollResponse(AtomicBoolean complete, VoteQuorum quorum, RaftMember member, PollResponse response, Throwable error) {
        this.raft.checkThread();
        if (this.isRunning() && !complete.get()) {
            if (error != null) {
                this.log.warn("Poll request to {} failed: {}", (Object)member.memberId(), (Object)error.getMessage());
                quorum.fail(member.memberId());
            } else {
                if (response.term() > this.raft.getTerm()) {
                    this.raft.setTerm(response.term());
                }
                if (!response.accepted()) {
                    this.log.debug("Received rejected poll from {}", (Object)member);
                    quorum.fail(member.memberId());
                } else if (response.term() != this.raft.getTerm()) {
                    this.log.debug("Received accepted poll for a different term from {}", (Object)member);
                    quorum.fail(member.memberId());
                } else {
                    this.log.debug("Received accepted poll from {}", (Object)member);
                    quorum.succeed(member.memberId());
                }
            }
        }
    }
}

