/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.atomix.raft.storage.serializer.ApplicationEntryDecoder;
import io.atomix.raft.storage.serializer.ApplicationEntryEncoder;
import io.atomix.raft.storage.serializer.ConfigurationEntryDecoder;
import io.atomix.raft.storage.serializer.ConfigurationEntryEncoder;
import io.atomix.raft.storage.serializer.EntryType;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.atomix.raft.storage.serializer.RaftLogEntryDecoder;
import io.atomix.raft.storage.serializer.RaftLogEntryEncoder;
import io.atomix.raft.storage.serializer.SerializerUtil;
import io.camunda.zeebe.journal.file.RecordDataEncoder;
import io.camunda.zeebe.util.SbeUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class RaftEntrySBESerializer
implements RaftEntrySerializer {
    final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    final RaftLogEntryEncoder raftLogEntryEncoder = new RaftLogEntryEncoder();
    final ApplicationEntryEncoder applicationEntryEncoder = new ApplicationEntryEncoder();
    final ConfigurationEntryEncoder configurationEntryEncoder = new ConfigurationEntryEncoder();
    final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    final RaftLogEntryDecoder raftLogEntryDecoder = new RaftLogEntryDecoder();
    final ApplicationEntryDecoder applicationEntryDecoder = new ApplicationEntryDecoder();
    final ConfigurationEntryDecoder configurationEntryDecoder = new ConfigurationEntryDecoder();

    @Override
    public int getApplicationEntrySerializedLength(ApplicationEntry entry) {
        return this.headerEncoder.encodedLength() + this.raftLogEntryEncoder.sbeBlockLength() + this.headerEncoder.encodedLength() + this.applicationEntryEncoder.sbeBlockLength() + RecordDataEncoder.dataHeaderLength() + entry.dataWriter().getLength();
    }

    @Override
    public int getInitialEntrySerializedLength() {
        return this.headerEncoder.encodedLength() + this.raftLogEntryEncoder.sbeBlockLength();
    }

    @Override
    public int getConfigurationEntrySerializedLength(ConfigurationEntry entry) {
        return this.headerEncoder.encodedLength() + this.raftLogEntryEncoder.sbeBlockLength() + this.headerEncoder.encodedLength() + this.configurationEntryEncoder.sbeBlockLength() + ConfigurationEntryDecoder.NewMembersDecoder.sbeHeaderSize() + entry.newMembers().stream().mapToInt(this::getNewMemberEntryLength).sum() + ConfigurationEntryDecoder.OldMembersDecoder.sbeHeaderSize() + entry.oldMembers().stream().mapToInt(this::getOldMemberEntryLength).sum();
    }

    @Override
    public int writeApplicationEntry(long term, ApplicationEntry entry, MutableDirectBuffer buffer, int offset) {
        int entryOffset = this.writeRaftFrame(term, EntryType.ApplicationEntry, buffer, offset);
        this.headerEncoder.wrap(buffer, offset + entryOffset).blockLength(this.applicationEntryEncoder.sbeBlockLength()).templateId(this.applicationEntryEncoder.sbeTemplateId()).schemaId(this.applicationEntryEncoder.sbeSchemaId()).version(this.applicationEntryEncoder.sbeSchemaVersion());
        this.applicationEntryEncoder.wrap(buffer, offset + entryOffset + this.headerEncoder.encodedLength());
        this.applicationEntryEncoder.lowestAsqn(entry.lowestPosition()).highestAsqn(entry.highestPosition());
        SbeUtil.writeNested((BufferWriter)entry.dataWriter(), (int)ApplicationEntryEncoder.applicationDataHeaderLength(), (MessageEncoderFlyweight)this.applicationEntryEncoder, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        return entryOffset + this.headerEncoder.encodedLength() + this.applicationEntryEncoder.encodedLength();
    }

    @Override
    public int writeInitialEntry(long term, InitialEntry entry, MutableDirectBuffer buffer, int offset) {
        return this.writeRaftFrame(term, EntryType.InitialEntry, buffer, offset);
    }

    @Override
    public int writeConfigurationEntry(long term, ConfigurationEntry entry, MutableDirectBuffer buffer, int offset) {
        int entryOffset = this.writeRaftFrame(term, EntryType.ConfigurationEntry, buffer, offset);
        this.headerEncoder.wrap(buffer, offset + entryOffset).blockLength(this.configurationEntryEncoder.sbeBlockLength()).templateId(this.configurationEntryEncoder.sbeTemplateId()).schemaId(this.configurationEntryEncoder.sbeSchemaId()).version(this.configurationEntryEncoder.sbeSchemaVersion());
        this.configurationEntryEncoder.wrap(buffer, offset + entryOffset + this.headerEncoder.encodedLength());
        this.configurationEntryEncoder.timestamp(entry.timestamp());
        ConfigurationEntryEncoder.NewMembersEncoder newMembersEncoder = this.configurationEntryEncoder.newMembersCount(entry.newMembers().size());
        for (RaftMember member : entry.newMembers()) {
            String memberId = (String)((Object)member.memberId().id());
            newMembersEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        ConfigurationEntryEncoder.OldMembersEncoder oldMembersEncoder = this.configurationEntryEncoder.oldMembersCount(entry.oldMembers().size());
        for (RaftMember member : entry.oldMembers()) {
            String memberId = (String)((Object)member.memberId().id());
            oldMembersEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        return entryOffset + this.headerEncoder.encodedLength() + this.configurationEntryEncoder.encodedLength();
    }

    @Override
    public RaftLogEntry readRaftLogEntry(DirectBuffer buffer) {
        this.headerDecoder.wrap(buffer, 0);
        this.raftLogEntryDecoder.wrap(buffer, this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long term = this.raftLogEntryDecoder.term();
        EntryType type = this.raftLogEntryDecoder.type();
        int entryOffset = this.headerDecoder.encodedLength() + this.raftLogEntryDecoder.encodedLength();
        InitialEntry entry = switch (type) {
            case EntryType.ApplicationEntry -> {
                this.headerDecoder.wrap(buffer, entryOffset);
                yield this.readApplicationEntry(buffer, entryOffset);
            }
            case EntryType.ConfigurationEntry -> {
                this.headerDecoder.wrap(buffer, entryOffset);
                yield this.readConfigurationEntry(buffer, entryOffset);
            }
            case EntryType.InitialEntry -> new InitialEntry();
            default -> throw new IllegalStateException("Unexpected entry type " + type);
        };
        return new RaftLogEntry(term, entry);
    }

    private int getNewMemberEntryLength(RaftMember raftMember) {
        String id = (String)((Object)raftMember.memberId().id());
        return ConfigurationEntryDecoder.NewMembersDecoder.sbeBlockLength() + ConfigurationEntryDecoder.NewMembersDecoder.memberIdHeaderLength() + (null == id || id.isEmpty() ? 0 : id.length());
    }

    private int getOldMemberEntryLength(RaftMember raftMember) {
        String id = (String)((Object)raftMember.memberId().id());
        return ConfigurationEntryDecoder.OldMembersDecoder.sbeBlockLength() + ConfigurationEntryDecoder.OldMembersDecoder.memberIdHeaderLength() + (null == id || id.isEmpty() ? 0 : id.length());
    }

    private int writeRaftFrame(long term, EntryType entryType, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.raftLogEntryEncoder.sbeBlockLength()).templateId(this.raftLogEntryEncoder.sbeTemplateId()).schemaId(this.raftLogEntryEncoder.sbeSchemaId()).version(this.raftLogEntryEncoder.sbeSchemaVersion());
        this.raftLogEntryEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.raftLogEntryEncoder.term(term);
        this.raftLogEntryEncoder.type(entryType);
        return this.headerEncoder.encodedLength() + this.raftLogEntryEncoder.encodedLength();
    }

    private ApplicationEntry readApplicationEntry(DirectBuffer buffer, int entryOffset) {
        this.applicationEntryDecoder.wrap(buffer, entryOffset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        UnsafeBuffer data = new UnsafeBuffer();
        this.applicationEntryDecoder.wrapApplicationData((DirectBuffer)data);
        return new SerializedApplicationEntry(this.applicationEntryDecoder.lowestAsqn(), this.applicationEntryDecoder.highestAsqn(), (DirectBuffer)data);
    }

    private ConfigurationEntry readConfigurationEntry(DirectBuffer buffer, int entryOffset) {
        this.configurationEntryDecoder.wrap(buffer, entryOffset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long timestamp = this.configurationEntryDecoder.timestamp();
        ConfigurationEntryDecoder.NewMembersDecoder newMembersDecoder = this.configurationEntryDecoder.newMembers();
        ArrayList<RaftMember> newMembers = new ArrayList<RaftMember>(newMembersDecoder.count());
        for (ConfigurationEntryDecoder.NewMembersDecoder member : newMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            newMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        ConfigurationEntryDecoder.OldMembersDecoder oldMembersDecoder = this.configurationEntryDecoder.oldMembers();
        ArrayList<RaftMember> oldMembers = new ArrayList<RaftMember>(oldMembersDecoder.count());
        for (ConfigurationEntryDecoder.OldMembersDecoder member : oldMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            oldMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        return new ConfigurationEntry(timestamp, newMembers, oldMembers);
    }
}

