/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3;

import io.camunda.zeebe.backup.api.NamedFileSet;
import io.camunda.zeebe.backup.common.NamedFileSetImpl;
import io.camunda.zeebe.backup.s3.S3BackupConfig;
import io.camunda.zeebe.backup.s3.manifest.FileSet;
import io.camunda.zeebe.backup.s3.util.CompletableFutureUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;

final class FileSetManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileSetManager.class);
    private static final int COMPRESSION_SIZE_THRESHOLD = 0x800000;
    private static final String TMP_COMPRESSION_PREFIX = "zb-backup-compress-";
    private static final String TMP_DECOMPRESSION_PREFIX = "zb-backup-decompress-";
    private final S3AsyncClient client;
    private final S3BackupConfig config;
    private final Semaphore uploadLimit;

    public FileSetManager(S3AsyncClient client, S3BackupConfig config) {
        this.client = client;
        this.config = config;
        this.uploadLimit = new Semaphore(Math.max(1, config.maxConcurrentConnections() / 2));
    }

    CompletableFuture<FileSet> save(String prefix, NamedFileSet files) {
        LOG.debug("Saving {} files to prefix {}", (Object)files.files().size(), (Object)prefix);
        return CompletableFutureUtils.mapAsync(files.namedFiles().entrySet(), Map.Entry::getKey, namedFile -> this.saveFile(prefix, (String)namedFile.getKey(), (Path)namedFile.getValue())).thenApply(FileSet::new);
    }

    private CompletableFuture<FileSet.FileMetadata> saveFile(String prefix, String fileName, Path filePath) {
        if (this.shouldCompressFile(filePath)) {
            String algorithm = this.config.compressionAlgorithm().orElseThrow();
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(this.uploadLimit::acquireUninterruptibly).thenApply(success -> this.compressFile(filePath, algorithm))).thenCompose(compressedFile -> {
                LOG.trace("Saving compressed file {}({}) in prefix {}", new Object[]{fileName, compressedFile, prefix});
                return ((CompletableFuture)this.client.putObject(put -> put.bucket(this.config.bucketName()).key(prefix + fileName), AsyncRequestBody.fromFile((Path)compressedFile)).thenRunAsync(() -> this.cleanupCompressedFile((Path)compressedFile))).thenApply(unused -> FileSet.FileMetadata.withCompression(algorithm));
            })).whenComplete((success, error) -> this.uploadLimit.release());
        }
        return ((CompletableFuture)CompletableFuture.runAsync(this.uploadLimit::acquireUninterruptibly).thenCompose(nothing -> {
            LOG.trace("Saving file {}({}) in prefix {}", new Object[]{fileName, filePath, prefix});
            return this.client.putObject(put -> put.bucket(this.config.bucketName()).key(prefix + fileName), AsyncRequestBody.fromFile((Path)filePath)).thenApply(unused -> FileSet.FileMetadata.none());
        })).whenComplete((success, error) -> this.uploadLimit.release());
    }

    private void cleanupCompressedFile(Path compressedFile) {
        try {
            Files.delete(compressedFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to clean up temporary file used for (de-)compression: {}", (Object)compressedFile, (Object)e);
        }
    }

    private boolean shouldCompressFile(Path filePath) {
        try {
            return this.config.compressionAlgorithm().isPresent() && Files.size(filePath) > 0x800000L;
        }
        catch (IOException e) {
            LOG.warn("Failed to determine if file should be compressed, assuming no: {}", (Object)filePath);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private Path compressFile(Path file, String algorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    CompletableFuture<NamedFileSet> restore(String sourcePrefix, FileSet fileSet, Path targetFolder) {
        LOG.debug("Restoring {} files from prefix {} to {}", new Object[]{fileSet.files().size(), sourcePrefix, targetFolder});
        return CompletableFutureUtils.mapAsync(fileSet.files().entrySet(), Map.Entry::getKey, namedFile -> this.restoreFile(sourcePrefix, targetFolder, (String)namedFile.getKey(), (FileSet.FileMetadata)namedFile.getValue())).thenApply(NamedFileSetImpl::new);
    }

    private CompletableFuture<Path> restoreFile(String sourcePrefix, Path targetFolder, String fileName, FileSet.FileMetadata metadata) {
        Optional<String> compressionAlgorithm = metadata.compressionAlgorithm();
        if (compressionAlgorithm.isPresent()) {
            Path decompressed = targetFolder.resolve(fileName);
            LOG.trace("Restoring compressed file {} from prefix {} to {}", new Object[]{fileName, sourcePrefix, targetFolder});
            try {
                Path compressed = Files.createTempFile(TMP_DECOMPRESSION_PREFIX, null, new FileAttribute[0]);
                return this.client.getObject(req -> req.bucket(this.config.bucketName()).key(sourcePrefix + fileName), AsyncResponseTransformer.toFile((Path)compressed, cfg -> cfg.fileWriteOption(FileTransformerConfiguration.FileWriteOption.CREATE_OR_REPLACE_EXISTING).failureBehavior(FileTransformerConfiguration.FailureBehavior.DELETE))).thenApplyAsync(response -> this.decompressFile(compressed, decompressed, (String)compressionAlgorithm.get()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LOG.trace("Restoring file {} from prefix {} to {}", new Object[]{fileName, sourcePrefix, targetFolder});
        Path path = targetFolder.resolve(fileName);
        return this.client.getObject(req -> req.bucket(this.config.bucketName()).key(sourcePrefix + fileName), path).thenApply(response -> path);
    }

    /*
     * Exception decompiling
     */
    private Path decompressFile(Path compressed, Path decompressed, String algorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

