/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.grpc;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.cmd.BrokerErrorException;
import io.camunda.zeebe.gateway.cmd.BrokerRejectionException;
import io.camunda.zeebe.gateway.cmd.IllegalTenantRequestException;
import io.camunda.zeebe.gateway.cmd.InvalidBrokerRequestArgumentException;
import io.camunda.zeebe.gateway.cmd.InvalidTenantRequestException;
import io.camunda.zeebe.gateway.cmd.NoTopologyAvailableException;
import io.camunda.zeebe.gateway.cmd.PartitionNotFoundException;
import io.camunda.zeebe.gateway.impl.broker.RequestRetriesExhaustedException;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerError;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerRejection;
import io.camunda.zeebe.msgpack.MsgpackPropertyException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.netty.channel.ConnectTimeoutException;
import java.net.ConnectException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public final class GrpcErrorMapper {
    public StatusRuntimeException mapError(Throwable error) {
        return this.mapError(error, Loggers.GATEWAY_LOGGER);
    }

    StatusRuntimeException mapError(Throwable error, Logger logger) {
        return StatusProto.toStatusRuntimeException((Status)this.mapErrorToStatus(error, logger));
    }

    private Status mapErrorToStatus(Throwable error, Logger logger) {
        return this.mapErrorToStatus(error, error, logger);
    }

    private Status mapErrorToStatus(Throwable rootError, Throwable error, Logger logger) {
        Status.Builder builder = Status.newBuilder();
        if (error instanceof ExecutionException) {
            return this.mapErrorToStatus(rootError, error.getCause(), logger);
        }
        if (error instanceof BrokerErrorException) {
            Status status = this.mapBrokerErrorToStatus(rootError, ((BrokerErrorException)error).getError(), logger);
            builder.mergeFrom(status);
        } else if (error instanceof BrokerRejectionException) {
            Status status = this.mapRejectionToStatus(((BrokerRejectionException)error).getRejection());
            builder.mergeFrom(status);
            logger.trace("Expected to handle gRPC request, but the broker rejected it", rootError);
        } else if (error instanceof TimeoutException) {
            builder.setCode(4).setMessage("Time out between gateway and broker: " + error.getMessage());
            logger.debug("Expected to handle gRPC request, but request timed out between gateway and broker", rootError);
        } else if (error instanceof InvalidBrokerRequestArgumentException) {
            builder.setCode(3).setMessage(error.getMessage());
            logger.debug("Expected to handle gRPC request, but broker argument was invalid", rootError);
        } else if (error instanceof MsgpackPropertyException) {
            builder.setCode(3).setMessage(error.getMessage());
            logger.debug("Expected to handle gRPC request, but messagepack property was invalid", rootError);
        } else if (error instanceof JsonParseException) {
            builder.setCode(3).setMessage(error.getMessage());
            logger.debug("Expected to handle gRPC request, but JSON property was invalid", rootError);
        } else if (error instanceof InvalidTenantRequestException) {
            builder.setCode(3).setMessage(error.getMessage());
            logger.debug(error.getMessage(), rootError);
        } else if (error instanceof IllegalTenantRequestException) {
            builder.setCode(7).setMessage(error.getMessage());
            logger.debug(error.getMessage(), rootError);
        } else if (error instanceof IllegalArgumentException) {
            builder.setCode(3).setMessage(error.getMessage());
            logger.debug("Expected to handle gRPC request, but JSON property was invalid 123", rootError);
        } else if (error instanceof PartitionNotFoundException) {
            builder.setCode(14).setMessage(error.getMessage());
            logger.debug("Expected to handle gRPC request, but request could not be delivered", rootError);
        } else if (error instanceof RequestRetriesExhaustedException) {
            builder.setCode(8).setMessage(error.getMessage());
            for (Throwable suppressed : error.getSuppressed()) {
                builder.addDetails(Any.pack((Message)this.mapErrorToStatus(rootError, suppressed, (Logger)NOPLogger.NOP_LOGGER)));
            }
            logger.trace("Expected to handle gRPC request, but all retries have been exhausted", rootError);
        } else if (error instanceof NoTopologyAvailableException) {
            builder.setCode(14).setMessage(error.getMessage());
            logger.trace("Expected to handle gRPC request, but the gateway does not know any partitions yet", rootError);
        } else if (error instanceof ConnectTimeoutException) {
            builder.setCode(14).setMessage(error.getMessage());
            logger.warn("Expected to handle gRPC request, but a connection timeout exception occurred", rootError);
        } else if (error instanceof ConnectException) {
            builder.setCode(14).setMessage(error.getMessage());
            logger.warn("Expected to handle gRPC request, but there was a connection error with one of the brokers", rootError);
        } else {
            builder.setCode(13).setMessage("Unexpected error occurred during the request processing: " + error.getMessage());
            logger.error("Expected to handle gRPC request, but an unexpected error occurred", rootError);
        }
        return builder.build();
    }

    private Status mapBrokerErrorToStatus(Throwable rootError, BrokerError error, Logger logger) {
        Status.Builder builder = Status.newBuilder();
        String message = error.getMessage();
        switch (error.getCode()) {
            case PROCESS_NOT_FOUND: {
                builder.setCode(5);
                break;
            }
            case RESOURCE_EXHAUSTED: {
                builder.setCode(8);
                logger.trace("Target broker is currently overloaded: {}", (Object)error, (Object)rootError);
                break;
            }
            case PARTITION_LEADER_MISMATCH: {
                logger.trace("Target broker was not the leader of the partition: {}", (Object)error, (Object)rootError);
                builder.setCode(14);
                break;
            }
            case MALFORMED_REQUEST: {
                builder.setCode(3);
                break;
            }
            default: {
                logger.error("Expected to handle gRPC request, but received an internal error from broker: {}", (Object)error, (Object)rootError);
                builder.setCode(13);
                message = String.format("Unexpected error occurred between gateway and broker (code: %s) (message: %s)", error.getCode(), error.getMessage());
            }
        }
        return builder.setMessage(message).build();
    }

    private Status mapRejectionToStatus(BrokerRejection rejection) {
        String message = String.format("Command '%s' rejected with code '%s': %s", rejection.intent(), rejection.type(), rejection.reason());
        Status.Builder builder = Status.newBuilder().setMessage(message);
        switch (rejection.type()) {
            case INVALID_ARGUMENT: {
                builder.setCode(3);
                break;
            }
            case NOT_FOUND: {
                builder.setCode(5);
                break;
            }
            case ALREADY_EXISTS: {
                builder.setCode(6);
                break;
            }
            case INVALID_STATE: {
                builder.setCode(9);
                break;
            }
            case PROCESSING_ERROR: {
                builder.setCode(13);
                break;
            }
            default: {
                builder.setCode(2);
            }
        }
        return builder.build();
    }
}

