/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import java.util.List;
import org.agrona.DirectBuffer;

public class BrokerCreateProcessInstanceRequest
extends BrokerExecuteCommand<ProcessInstanceCreationRecord> {
    private final ProcessInstanceCreationRecord requestDto = new ProcessInstanceCreationRecord();

    public BrokerCreateProcessInstanceRequest() {
        super(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE);
    }

    public BrokerCreateProcessInstanceRequest setBpmnProcessId(String bpmnProcessId) {
        this.requestDto.setBpmnProcessId(bpmnProcessId);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setKey(long key) {
        this.requestDto.setProcessDefinitionKey(key);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setVersion(int version) {
        this.requestDto.setVersion(version);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setTenantId(String tenantId) {
        this.requestDto.setTenantId(tenantId);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setStartInstructions(List<GatewayOuterClass.ProcessInstanceCreationStartInstruction> startInstructionsList) {
        startInstructionsList.stream().map(startInstructionReq -> new ProcessInstanceCreationStartInstruction().setElementId(startInstructionReq.getElementId())).forEach(arg_0 -> ((ProcessInstanceCreationRecord)this.requestDto).addStartInstruction(arg_0));
        return this;
    }

    public ProcessInstanceCreationRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected ProcessInstanceCreationRecord toResponseDto(DirectBuffer buffer) {
        ProcessInstanceCreationRecord responseDto = new ProcessInstanceCreationRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

