/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.stream;

import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class JobClientStreamMetrics
implements ClientStreamMetrics {
    private static final String NAMESPACE = "zeebe_gateway_job_stream";
    private static final Gauge SERVERS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe_gateway_job_stream")).name("servers")).help("The count of known job stream servers/brokers")).register();
    private static final Gauge CLIENTS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe_gateway_job_stream")).name("clients")).help("The count of known job stream clients")).register();
    private static final Gauge AGGREGATED_STREAMS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe_gateway_job_stream")).name("streams")).help("Total count of aggregated streams")).register();
    private static final Histogram AGGREGATED_CLIENTS = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe_gateway_job_stream")).name("aggregated_stream_clients")).help("Distribution of client count per aggregated stream")).register();
    private static final Counter PUSHES = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe_gateway_job_stream")).name("push")).help("Count of pushed payloads, tagged by result status (success, failure)")).labelNames(new String[]{"status"})).register();
    private final Counter.Child pushSuccessCount = (Counter.Child)PUSHES.labels(new String[]{"success"});
    private final Counter.Child pushFailureCount = (Counter.Child)PUSHES.labels(new String[]{"failure"});

    JobClientStreamMetrics() {
    }

    public void serverCount(int count) {
        SERVERS.set((double)count);
    }

    public void clientCount(int count) {
        CLIENTS.set((double)count);
    }

    public void aggregatedStreamCount(int count) {
        AGGREGATED_STREAMS.set((double)count);
    }

    public void observeAggregatedClientCount(int count) {
        AGGREGATED_CLIENTS.observe((double)count);
    }

    public void pushSucceeded() {
        this.pushSuccessCount.inc();
    }

    public void pushFailed() {
        this.pushFailureCount.inc();
    }
}

