/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.stream;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.gateway.impl.stream.JobClientStreamMetrics;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.TransportFactory;
import io.camunda.zeebe.transport.stream.api.ClientStream;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.api.ClientStreamService;
import io.camunda.zeebe.transport.stream.api.ClientStreamer;
import java.util.Collection;

public final class JobStreamClientImpl
implements JobStreamClient {
    private final ActorSchedulingService schedulingService;
    private final ClientStreamService<JobActivationProperties> streamService;
    private boolean started;
    private ActorFuture<Void> startedFuture;

    public JobStreamClientImpl(ActorSchedulingService schedulingService, ClusterCommunicationService clusterCommunicationService) {
        this.schedulingService = schedulingService;
        this.streamService = new TransportFactory(schedulingService).createRemoteStreamClient(clusterCommunicationService, (ClientStreamMetrics)new JobClientStreamMetrics());
    }

    @Override
    public synchronized void brokerAdded(MemberId memberId) {
        if (!this.started) {
            return;
        }
        this.streamService.onServerJoined(memberId);
    }

    @Override
    public synchronized void brokerRemoved(MemberId memberId) {
        if (!this.started) {
            return;
        }
        this.streamService.onServerRemoved(memberId);
    }

    @Override
    public ClientStreamer<JobActivationProperties> streamer() {
        return this.streamService.streamer();
    }

    @Override
    public synchronized ActorFuture<Void> start() {
        if (this.startedFuture == null) {
            this.startedFuture = this.streamService.start(this.schedulingService);
            this.started = true;
        }
        return this.startedFuture;
    }

    @Override
    public ActorFuture<Collection<ClientStream<JobActivationProperties>>> list() {
        return this.streamService.streams();
    }

    public synchronized void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.streamService.closeAsync().join();
    }
}

