/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.zeebe.gateway.interceptors.InterceptorUtil;
import io.camunda.zeebe.gateway.query.QueryApi;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.agrona.LangUtil;

public final class ContextInjectingInterceptor
implements ServerInterceptor {
    private final QueryApi queryApi;

    public ContextInjectingInterceptor(QueryApi queryApi) {
        this.queryApi = queryApi;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            return (ServerCall.Listener)Context.current().withValue(InterceptorUtil.getQueryApiKey(), (Object)this.queryApi).call(() -> next.startCall(call, headers));
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }
}

