/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import io.camunda.zeebe.shared.IdleStrategyConfig;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public final class ActorSchedulerConfiguration {
    private final BrokerCfg brokerCfg;
    private final ActorClockConfiguration actorClockConfiguration;
    private final MeterRegistry meterRegistry;

    @Autowired
    public ActorSchedulerConfiguration(BrokerConfiguration config, ActorClockConfiguration actorClockConfiguration, MeterRegistry meterRegistry) {
        this.brokerCfg = config.config();
        this.actorClockConfiguration = actorClockConfiguration;
        this.meterRegistry = meterRegistry;
    }

    @Bean(destroyMethod="close")
    public ActorScheduler scheduler(IdleStrategyConfig.IdleStrategySupplier idleStrategySupplier) {
        ThreadsCfg cfg = this.brokerCfg.getThreads();
        int cpuThreads = cfg.getCpuThreadCount();
        int ioThreads = cfg.getIoThreadCount();
        boolean metricsEnabled = this.brokerCfg.getExperimental().getFeatures().isEnableActorMetrics();
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock((ActorClock)this.actorClockConfiguration.getClock().orElse(null)).setCpuBoundActorThreadCount(cpuThreads).setIoBoundActorThreadCount(ioThreads).setMeterRegistry(metricsEnabled ? this.meterRegistry : null).setSchedulerName(String.format("Broker-%d", this.brokerCfg.getCluster().getNodeId())).setIdleStrategySupplier((Supplier)idleStrategySupplier).build();
        scheduler.start();
        return scheduler;
    }
}

