/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerClientRequestMetrics;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerClientImpl;
import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
final class BrokerClientConfiguration {
    private final BrokerCfg config;
    private final AtomixCluster cluster;
    private final ActorScheduler scheduler;
    private final BrokerTopologyManager topologyManager;
    private final BrokerClientRequestMetrics metrics;

    @Autowired
    BrokerClientConfiguration(BrokerConfiguration config, AtomixCluster cluster, ActorScheduler scheduler, BrokerTopologyManager topologyManager, MeterRegistry registry) {
        this.config = config.config();
        this.cluster = cluster;
        this.scheduler = scheduler;
        this.topologyManager = topologyManager;
        this.metrics = BrokerClientRequestMetrics.of((MeterRegistry)registry);
    }

    @Bean(destroyMethod="close")
    BrokerClient brokerClient() {
        BrokerClientImpl brokerClient = new BrokerClientImpl(this.config.getGateway().getCluster().getRequestTimeout(), this.cluster.getMessagingService(), this.cluster.getEventService(), (ActorSchedulingService)this.scheduler, this.topologyManager, this.metrics);
        brokerClient.start().forEach(ActorFuture::join);
        return brokerClient;
    }
}

