/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterConfig;
import io.atomix.utils.Version;
import io.camunda.zeebe.broker.clustering.ClusterConfigFactory;
import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.util.VersionUtil;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public final class BrokerClusterConfiguration {
    private MeterRegistry meterRegistry;

    @Bean
    public ClusterConfig clusterConfig(BrokerConfiguration config, MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        ClusterConfigFactory configFactory = new ClusterConfigFactory();
        return configFactory.mapConfiguration(config.config());
    }

    @Bean(destroyMethod="stop")
    public AtomixCluster atomixCluster(ClusterConfig config) {
        return new AtomixCluster(config, Version.from((String)VersionUtil.getVersion()), this.meterRegistry);
    }
}

