/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.jobstream.JobStreamService;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.shared.management.JobStreamEndpoint;
import io.camunda.zeebe.transport.stream.api.ClientStream;
import io.camunda.zeebe.transport.stream.api.RemoteStreamInfo;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="jobStreamService")
final class BrokerJobStreamService
implements JobStreamEndpoint.Service {
    private final SpringBrokerBridge bridge;

    @Autowired
    public BrokerJobStreamService(SpringBrokerBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public Collection<RemoteStreamInfo<JobActivationProperties>> remoteJobStreams() {
        return this.bridge.getJobStreamService().map(JobStreamService::remoteStreamService).map(RemoteStreamService::streams).orElse(Collections.emptyList());
    }

    @Override
    public Collection<ClientStream<JobActivationProperties>> clientJobStreams() {
        return this.bridge.getJobStreamClient().map(JobStreamClient::list).map(ActorFuture::join).orElse(Collections.emptyList());
    }
}

