/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.BrokerShutdownHelper;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.broker.shared.WorkingDirectoryConfiguration;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.shared.MainSupport;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.util.FileUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(proxyBeanMethods=false, scanBasePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared", "io.camunda.zeebe.gateway.rest"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
public class StandaloneBroker
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOGGER = Loggers.SYSTEM_LOGGER;
    private final BrokerConfiguration configuration;
    private final IdentityConfiguration identityConfiguration;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorScheduler actorScheduler;
    private final AtomixCluster cluster;
    private final BrokerClient brokerClient;
    private final MeterRegistry meterRegistry;
    @Autowired
    private BrokerShutdownHelper shutdownHelper;
    private Broker broker;

    @Autowired
    public StandaloneBroker(BrokerConfiguration configuration, IdentityConfiguration identityConfiguration, SpringBrokerBridge springBrokerBridge, ActorScheduler actorScheduler, AtomixCluster cluster, BrokerClient brokerClient, MeterRegistry meterRegistry) {
        this.configuration = configuration;
        this.identityConfiguration = identityConfiguration;
        this.springBrokerBridge = springBrokerBridge;
        this.actorScheduler = actorScheduler;
        this.cluster = cluster;
        this.brokerClient = brokerClient;
        this.meterRegistry = meterRegistry;
    }

    public static void main(String[] args) {
        MainSupport.setDefaultGlobalConfiguration();
        MainSupport.putSystemPropertyIfAbsent("spring.banner.location", "classpath:/assets/zeebe_broker_banner.txt");
        SpringApplication application = MainSupport.createDefaultApplicationBuilder().sources(new Class[]{StandaloneBroker.class}).profiles(new String[]{Profile.BROKER.getId()}).build(args);
        application.run(new String[0]);
    }

    public void run(String ... args) throws IOException {
        SystemContext systemContext = new SystemContext(this.configuration.shutdownTimeout(), this.configuration.config(), this.identityConfiguration, this.actorScheduler, this.cluster, this.brokerClient, this.meterRegistry);
        this.springBrokerBridge.registerShutdownHelper(errorCode -> this.shutdownHelper.initiateShutdown((int)errorCode));
        this.broker = new Broker(systemContext, this.springBrokerBridge);
        this.broker.start();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            this.broker.close();
        }
        finally {
            this.cleanupWorkingDirectory();
        }
    }

    private void cleanupWorkingDirectory() {
        WorkingDirectoryConfiguration.WorkingDirectory workingDirectory = this.configuration.workingDirectory();
        if (!workingDirectory.isTemporary()) {
            return;
        }
        LOGGER.debug("Deleting broker temporary working directory {}", (Object)workingDirectory.path());
        try {
            FileUtil.deleteFolderIfExists((Path)workingDirectory.path());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete temporary directory {}", (Object)workingDirectory.path());
        }
    }
}

