/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.broker.client.api.BrokerClientTopologyMetrics;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerTopologyManagerImpl;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.topology.api.TopologyCoordinatorSupplier;
import io.camunda.zeebe.topology.api.TopologyManagementRequestSender;
import io.camunda.zeebe.topology.serializer.ProtoBufSerializer;
import io.camunda.zeebe.topology.serializer.TopologyRequestsSerializer;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class TopologyServices {
    private final ActorScheduler scheduler;
    private final ClusterMembershipService clusterMembershipService;
    private final ClusterCommunicationService clusterCommunicationService;
    private final BrokerClientTopologyMetrics metrics;

    @Autowired
    public TopologyServices(ActorScheduler scheduler, AtomixCluster atomixCluster, MeterRegistry registry) {
        this.scheduler = scheduler;
        this.clusterMembershipService = atomixCluster.getMembershipService();
        this.clusterCommunicationService = atomixCluster.getCommunicationService();
        this.metrics = BrokerClientTopologyMetrics.of((MeterRegistry)registry);
    }

    @Bean
    BrokerTopologyManager brokerTopologyManager() {
        BrokerTopologyManagerImpl brokerTopologyManager = new BrokerTopologyManagerImpl(() -> ((ClusterMembershipService)this.clusterMembershipService).getMembers(), this.metrics);
        this.scheduler.submitActor((Actor)brokerTopologyManager).join();
        this.clusterMembershipService.addListener((EventListener)brokerTopologyManager);
        return brokerTopologyManager;
    }

    @Bean
    TopologyManagementRequestSender topologyManagementRequestSender(BrokerTopologyManager brokerTopologyManager) {
        return new TopologyManagementRequestSender(this.clusterCommunicationService, (TopologyCoordinatorSupplier)new TopologyCoordinatorSupplier.ClusterTopologyAwareCoordinatorSupplier(() -> ((BrokerTopologyManager)brokerTopologyManager).getClusterTopology()), (TopologyRequestsSerializer)new ProtoBufSerializer());
    }
}

