/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.health;

import io.camunda.zeebe.shared.management.ConditionalOnManagementContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Mono;

@Profile(value={"broker"})
@ConditionalOnManagementContext
@ManagementContextConfiguration(value=ManagementContextType.ANY, proxyBeanMethods=false)
public class BrokerHealthRoutes {
    private final UriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
    private final ManagementServerProperties serverProperties;
    private final WebEndpointProperties actuatorProperties;

    @Autowired
    public BrokerHealthRoutes(ManagementServerProperties serverProperties, WebEndpointProperties actuatorProperties) {
        this.serverProperties = serverProperties;
        this.actuatorProperties = actuatorProperties;
    }

    @Bean
    public RouterFunction<ServerResponse> routes() {
        String serverBasePath = this.serverProperties.getBasePath();
        String actuatorBasePath = this.actuatorProperties.getBasePath();
        return RouterFunctions.route().GET("/health", req -> this.movedPermanently(serverBasePath, actuatorBasePath, "/health/status")).GET("/ready", req -> this.movedPermanently(serverBasePath, actuatorBasePath, "/health/readiness")).GET("/startup", req -> this.movedPermanently(serverBasePath, actuatorBasePath, "/health/startup")).build();
    }

    private Mono<ServerResponse> movedPermanently(String ... paths) {
        UriBuilder builder = this.uriBuilderFactory.builder();
        for (String path : paths) {
            builder.path(path);
        }
        return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.MOVED_PERMANENTLY).location(builder.build(new Object[0]))).build();
    }
}

