/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.health;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.stereotype.Component;

@Component
public final class BrokerReadyHealthIndicator
extends ReadinessStateHealthIndicator {
    private final SpringBrokerBridge brokerBridge;

    @Autowired
    public BrokerReadyHealthIndicator(ApplicationAvailability availability, SpringBrokerBridge brokerBridge) {
        super(availability);
        this.brokerBridge = brokerBridge;
    }

    protected AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        Boolean isBrokerReady = this.brokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerReady).orElse(false);
        return isBrokerReady != false ? ReadinessState.ACCEPTING_TRAFFIC : ReadinessState.REFUSING_TRAFFIC;
    }
}

